/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.util.concurrency.SwingWorker;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractStepWithProgress<Result>
extends ModuleWizardStep {
    @NonNls
    private static final String PROGRESS_PANEL = "progress_panel";
    @NonNls
    private static final String RESULTS_PANEL = "results_panel";
    private JPanel myPanel;
    private JLabel myTitleLabel;
    private JLabel myProgressLabel;
    private JLabel myProgressLabel2;
    private ProgressIndicator myProgressIndicator = null;
    private final String myPromptStopSearch;

    public AbstractStepWithProgress(String promptStopSearching) {
        this.myPromptStopSearch = promptStopSearching;
    }

    public final JComponent getComponent() {
        if (this.myPanel == null) {
            this.myPanel = new JPanel(new CardLayout());
            this.myPanel.setBorder(BorderFactory.createEtchedBorder());
            this.myPanel.add((Component)this.createProgressPanel(), PROGRESS_PANEL);
            this.myPanel.add((Component)this.createResultsPanel(), RESULTS_PANEL);
        }
        return this.myPanel;
    }

    protected abstract JComponent createResultsPanel();

    protected abstract String getProgressText();

    protected abstract boolean shouldRunProgress();

    protected abstract Result calculate();

    protected abstract void onFinished(Result var1, boolean var2);

    private JPanel createProgressPanel() {
        JPanel progressPanel = new JPanel(new GridBagLayout());
        this.myTitleLabel = new JLabel();
        this.myTitleLabel.setFont(UIManager.getFont("Label.font").deriveFont(1));
        progressPanel.add((Component)this.myTitleLabel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 5, 10), 0, 0));
        this.myProgressLabel = new JLabel();
        progressPanel.add((Component)this.myProgressLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(8, 10, 0, 10), 0, 0));
        this.myProgressLabel2 = new JLabel();
        progressPanel.add((Component)this.myProgressLabel2, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(8, 10, 0, 10), 0, 0));
        JButton stopButton = new JButton(IdeBundle.message((String)"button.stop.searching", (Object[])new Object[0]));
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractStepWithProgress.this.cancelSearch();
            }
        });
        progressPanel.add((Component)stopButton, new GridBagConstraints(1, -1, 1, 2, 0.0, 1.0, 18, 0, new Insets(10, 0, 0, 10), 0, 0));
        return progressPanel;
    }

    private void cancelSearch() {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.cancel();
        }
    }

    private synchronized boolean isProgressRunning() {
        return this.myProgressIndicator != null && this.myProgressIndicator.isRunning();
    }

    public void updateStep() {
        if (this.shouldRunProgress()) {
            this.runProgress();
        } else {
            this.showCard(RESULTS_PANEL);
        }
    }

    protected void runProgress() {
        final MyProgressIndicator progress = new MyProgressIndicator();
        progress.setModalityProgress(null);
        String title = this.getProgressText();
        if (title != null) {
            this.myTitleLabel.setText(title);
        }
        this.showCard(PROGRESS_PANEL);
        this.myProgressIndicator = progress;
        new SwingWorker(){

            public Object construct() {
                final Ref result = Ref.create(null);
                ProgressManager.getInstance().runProcess(new Runnable(){

                    @Override
                    public void run() {
                        result.set(AbstractStepWithProgress.this.calculate());
                    }
                }, (ProgressIndicator)progress);
                return result.get();
            }

            public void finished() {
                AbstractStepWithProgress.this.myProgressIndicator = null;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object result = this.get();
                        AbstractStepWithProgress.this.onFinished(result, progress.isCanceled());
                        AbstractStepWithProgress.this.showCard(AbstractStepWithProgress.RESULTS_PANEL);
                    }
                });
            }
        }.start();
    }

    private void showCard(String id) {
        ((CardLayout)this.myPanel.getLayout()).show(this.myPanel, id);
        this.myPanel.revalidate();
    }

    public boolean validate() {
        if (this.isProgressRunning()) {
            int answer = Messages.showDialog((Component)this.getComponent(), (String)this.myPromptStopSearch, (String)IdeBundle.message((String)"title.question", (Object[])new Object[0]), (String[])new String[]{IdeBundle.message((String)"action.continue.searching", (Object[])new Object[0]), IdeBundle.message((String)"action.stop.searching", (Object[])new Object[0])}, (int)0, (Icon)Messages.getWarningIcon());
            if (answer == 1) {
                this.cancelSearch();
            }
            return false;
        }
        return true;
    }

    public void onStepLeaving() {
        if (this.isProgressRunning()) {
            this.cancelSearch();
        }
    }

    protected class MyProgressIndicator
    extends ProgressIndicatorBase {
        protected MyProgressIndicator() {
        }

        @Override
        public void setText(String text) {
            this.updateLabel(AbstractStepWithProgress.this.myProgressLabel, text);
            super.setText(text);
        }

        @Override
        public void setText2(String text) {
            this.updateLabel(AbstractStepWithProgress.this.myProgressLabel2, text);
            super.setText2(text);
        }

        private void updateLabel(final JLabel label, final String text) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    label.setText(text);
                }
            });
        }
    }
}

