/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksPanel;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SupportForFrameworksStep
extends ModuleWizardStep {
    private final AddSupportForFrameworksPanel mySupportForFrameworksPanel;
    private boolean myCommitted;

    public SupportForFrameworksStep(final ModuleBuilder builder, @NotNull LibrariesContainer librariesContainer) {
        if (librariesContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/SupportForFrameworksStep.<init> must not be null");
        }
        List<FrameworkSupportProvider> providers = FrameworkSupportUtil.getProviders(builder);
        this.mySupportForFrameworksPanel = new AddSupportForFrameworksPanel(providers, librariesContainer, builder, new Computable<String>(){

            public String compute() {
                return SupportForFrameworksStep.getBaseDirectory(builder);
            }
        });
        builder.addModuleConfigurationUpdater(new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                if (module == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/SupportForFrameworksStep$2.update must not be null");
                }
                if (rootModel == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/util/newProjectWizard/SupportForFrameworksStep$2.update must not be null");
                }
                SupportForFrameworksStep.this.mySupportForFrameworksPanel.addSupport(module, rootModel);
            }
        });
    }

    private static String getBaseDirectory(ModuleBuilder builder) {
        String path = null;
        if (builder instanceof JavaModuleBuilder) {
            path = ((JavaModuleBuilder)builder).getContentEntryPath();
        }
        if (path == null) {
            path = builder.getModuleFileDirectory();
        }
        return path != null ? FileUtil.toSystemIndependentName((String)path) : "";
    }

    public Icon getIcon() {
        return ICON;
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.technologies";
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        if (finishChosen && !this.myCommitted) {
            int answer;
            boolean ok = this.mySupportForFrameworksPanel.downloadLibraries();
            if (!ok && (answer = Messages.showYesNoDialog((Component)this.getComponent(), (String)ProjectBundle.message((String)"warning.message.some.required.libraries.wasn.t.downloaded", (Object[])new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon())) != 0) {
                throw new CommitStepException(null);
            }
            this.myCommitted = true;
        }
    }

    public JComponent getComponent() {
        return this.mySupportForFrameworksPanel.getMainPanel();
    }

    public void updateDataModel() {
    }
}

