/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.newProjectWizard.modes.CreateFromScratchMode;
import com.intellij.ide.util.newProjectWizard.modes.CreateFromSourcesMode;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NonNls;

public class ProjectCreateModeStep
extends ModuleWizardStep {
    private static final Icon NEW_PROJECT_ICON = IconLoader.getIcon((String)"/newprojectwizard.png");
    private final JPanel myWholePanel;
    private WizardMode myMode;
    private final List<WizardMode> myModes = new ArrayList<WizardMode>();
    private final WizardContext myWizardContext;

    public ProjectCreateModeStep(String defaultPath, WizardContext wizardContext) {
        StringBuffer buf = new StringBuffer();
        for (WizardMode mode : (WizardMode[])Extensions.getExtensions(WizardMode.MODES)) {
            String footnote;
            if (mode.isAvailable(wizardContext)) {
                this.myModes.add(mode);
                if (defaultPath != null) {
                    if (mode instanceof CreateFromSourcesMode) {
                        this.myMode = mode;
                    }
                } else if (mode instanceof CreateFromScratchMode) {
                    this.myMode = mode;
                }
            }
            if ((footnote = mode.getFootnote(wizardContext)) == null) continue;
            if (buf.length() > 0) {
                buf.append("<br>");
            }
            buf.append(footnote);
        }
        this.myWizardContext = wizardContext;
        this.myWholePanel = new JPanel(new GridBagLayout());
        this.myWholePanel.setBorder(BorderFactory.createEtchedBorder());
        Insets insets = new Insets(0, 0, 0, 5);
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        ButtonGroup group = new ButtonGroup();
        for (final WizardMode mode : this.myModes) {
            insets.top = 15;
            insets.left = 5;
            JRadioButton rb = new JRadioButton(mode.getDisplayName(wizardContext), mode == this.myMode);
            rb.setFont(UIUtil.getLabelFont().deriveFont(1));
            rb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectCreateModeStep.this.myMode.onChosen(false);
                    ProjectCreateModeStep.this.myMode = mode;
                    ProjectCreateModeStep.this.myMode.onChosen(true);
                    ProjectCreateModeStep.this.update();
                }
            });
            this.myWholePanel.add((Component)rb, gc);
            group.add(rb);
            insets.top = 5;
            insets.left = 20;
            JLabel description = new JLabel(mode.getDescription(wizardContext));
            this.myWholePanel.add((Component)description, gc);
            JComponent settings = mode.getAdditionalSettings();
            if (settings == null) continue;
            this.myWholePanel.add((Component)settings, gc);
        }
        gc.weighty = 1.0;
        gc.fill = 1;
        this.myWholePanel.add((Component)Box.createVerticalBox(), gc);
        JLabel note = new JLabel("<html>" + buf.toString() + "</html>", IconLoader.getIcon((String)"/nodes/warningIntroduction.png"), 2);
        note.setVisible(buf.length() > 0);
        gc.weighty = 0.0;
        gc.fill = 2;
        gc.insets.bottom = 5;
        this.myWholePanel.add((Component)note, gc);
    }

    public JComponent getComponent() {
        return this.myWholePanel;
    }

    public void updateDataModel() {
        this.myWizardContext.setProjectBuilder(this.myMode.getModuleBuilder());
    }

    public Icon getIcon() {
        return this.myWizardContext.getProject() == null ? NEW_PROJECT_ICON : ICON;
    }

    public WizardMode getMode() {
        return this.myMode;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        for (WizardMode mode : this.myModes) {
            Disposer.dispose((Disposable)mode);
        }
    }

    protected void update() {
    }

    public boolean validate() throws ConfigurationException {
        return super.validate() && this.myMode.validate();
    }

    @NonNls
    public String getHelpId() {
        return this.myWizardContext.getProject() == null ? "reference.dialogs.new.project" : "reference.dialogs.new.module";
    }

    public List<WizardMode> getModes() {
        return this.myModes;
    }
}

