/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import java.io.File;
import java.util.Collection;
import java.util.Collections;

public class LibraryDescriptor {
    private String myName;
    private final Collection<File> myJars;
    private Level myLevel;

    public LibraryDescriptor(String name, Collection<File> jars) {
        this.myName = name;
        this.myJars = jars;
    }

    public String getName() {
        return this.myName != null ? this.myName : "";
    }

    public void setName(String name) {
        this.myName = name;
    }

    public Level getLevel() {
        if (this.myLevel != null) {
            return this.myLevel;
        }
        return this.myJars.size() > 1 ? Level.PROJECT : Level.MODULE;
    }

    public void setLevel(Level level) {
        this.myLevel = level;
    }

    public Collection<File> getJars() {
        return Collections.unmodifiableCollection(this.myJars);
    }

    public void addJars(Collection<File> jars) {
        this.myJars.addAll(jars);
    }

    public void removeJars(Collection<File> jars) {
        this.myJars.removeAll(jars);
    }

    public String toString() {
        return "Lib[" + this.myName + "]";
    }

    public static enum Level {
        GLOBAL,
        PROJECT,
        MODULE;

    }
}

