/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class StructureViewModelWrapper
implements StructureViewModel {
    private final StructureViewModel myStructureViewModel;
    private final PsiFile myMainFile;

    public StructureViewModelWrapper(StructureViewModel structureViewModel, PsiFile mainFile) {
        this.myStructureViewModel = structureViewModel;
        this.myMainFile = mainFile;
    }

    public Object getCurrentEditorElement() {
        return this.myStructureViewModel.getCurrentEditorElement();
    }

    public void addEditorPositionListener(FileEditorPositionListener listener) {
        this.myStructureViewModel.addEditorPositionListener(listener);
    }

    public void removeEditorPositionListener(FileEditorPositionListener listener) {
        this.myStructureViewModel.removeEditorPositionListener(listener);
    }

    public void addModelListener(ModelListener modelListener) {
        this.myStructureViewModel.addModelListener(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.myStructureViewModel.removeModelListener(modelListener);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        StructureViewElementWrapper structureViewElementWrapper = new StructureViewElementWrapper(this.myStructureViewModel.getRoot(), this.myMainFile);
        if (structureViewElementWrapper == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/StructureViewModelWrapper.getRoot must not return null");
        }
        return structureViewElementWrapper;
    }

    public void dispose() {
        this.myStructureViewModel.dispose();
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    @NotNull
    public Grouper[] getGroupers() {
        Grouper[] grouperArray = this.myStructureViewModel.getGroupers();
        if (grouperArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/StructureViewModelWrapper.getGroupers must not return null");
        }
        return grouperArray;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = this.myStructureViewModel.getSorters();
        if (sorterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/StructureViewModelWrapper.getSorters must not return null");
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        Filter[] filterArray = this.myStructureViewModel.getFilters();
        if (filterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/StructureViewModelWrapper.getFilters must not return null");
        }
        return filterArray;
    }
}

