/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.dataRules;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;

public class ModuleRule
implements GetDataRule {
    @Override
    public Object getData(DataProvider dataProvider) {
        GetDataRule dataRule;
        VirtualFile virtualFile;
        Object moduleContext = LangDataKeys.MODULE_CONTEXT.getData(dataProvider);
        if (moduleContext != null) {
            return moduleContext;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataProvider);
        if (project == null) {
            PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataProvider);
            if (element == null || !element.isValid()) {
                return null;
            }
            project = element.getProject();
        }
        if ((virtualFile = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(dataProvider)) == null && (dataRule = ((DataManagerImpl)DataManager.getInstance()).getDataRule(PlatformDataKeys.VIRTUAL_FILE.getName())) != null) {
            virtualFile = (VirtualFile)dataRule.getData(dataProvider);
        }
        if (virtualFile == null) {
            return null;
        }
        return ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
    }
}

