/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.PosBufferTokenizer;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;

public class SyntaxTableLexer
extends LexerBase {
    private final SyntaxTable table;
    private final PosBufferTokenizer tokenizer;
    private IElementType tokenType;
    private int tokenStart;
    private int tokenEnd;
    private final String lineComment;
    private final String startComment;
    private final String endComment;
    private CharSequence buffer;
    private int startOffset;
    private int endOffset;
    private boolean firstCall;

    public SyntaxTableLexer(SyntaxTable table) {
        this.table = table;
        this.tokenizer = new PosBufferTokenizer();
        this.tokenizer.setIgnoreCase(table.isIgnoreCase());
        this.tokenizer.setHexPrefix(table.getHexPrefix());
        this.tokenizer.setNumPostifxChars(table.getNumPostfixChars());
        this.tokenizer.ordinaryChar(47);
        this.tokenizer.ordinaryChar(46);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.wordChars(95, 95);
        this.lineComment = table.getLineComment();
        this.startComment = table.getStartComment();
        this.endComment = table.getEndComment();
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.buffer = buffer;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.tokenType = null;
        this.tokenizer.start(buffer, startOffset, endOffset);
        this.firstCall = true;
    }

    private void parseToken() {
        String st = null;
        int ttype = this.tokenizer.nextToken();
        switch (ttype) {
            case -1: {
                this.tokenStart = this.endOffset;
                this.tokenEnd = this.endOffset;
                this.tokenType = null;
                return;
            }
            case -6: {
                this.tokenType = CustomHighlighterTokenType.WHITESPACE;
                break;
            }
            case -3: {
                st = this.tokenizer.sval;
                if (this.table.getKeywords1().contains(st)) {
                    this.tokenType = CustomHighlighterTokenType.KEYWORD_1;
                    break;
                }
                if (this.table.getKeywords2().contains(st)) {
                    this.tokenType = CustomHighlighterTokenType.KEYWORD_2;
                    break;
                }
                if (this.table.getKeywords3().contains(st)) {
                    this.tokenType = CustomHighlighterTokenType.KEYWORD_3;
                    break;
                }
                if (this.table.getKeywords4().contains(st)) {
                    this.tokenType = CustomHighlighterTokenType.KEYWORD_4;
                    break;
                }
                this.tokenType = CustomHighlighterTokenType.IDENTIFIER;
                break;
            }
            case -2: {
                this.tokenType = CustomHighlighterTokenType.NUMBER;
                break;
            }
            case -5: {
                this.tokenType = CustomHighlighterTokenType.STRING;
                break;
            }
            default: {
                if (this.lineComment != null && !"".equals(this.lineComment.trim()) && ttype == this.lineComment.charAt(0) && this.tokenizer.matchString(this.lineComment, 1)) {
                    this.tokenType = CustomHighlighterTokenType.LINE_COMMENT;
                    this.tokenStart = this.tokenizer.getPos() - this.lineComment.length();
                    this.tokenizer.skipToEol();
                    this.tokenEnd = this.tokenizer.getPos();
                    return;
                }
                if (this.startComment != null && !"".equals(this.startComment.trim()) && ttype == this.startComment.charAt(0) && this.tokenizer.matchString(this.startComment, 1)) {
                    this.tokenType = CustomHighlighterTokenType.MULTI_LINE_COMMENT;
                    this.tokenStart = this.tokenizer.getPos() - this.startComment.length();
                    this.tokenizer.skipToStr(this.endComment);
                    this.tokenEnd = this.tokenizer.getPos();
                    return;
                }
                this.tokenType = CustomHighlighterTokenType.CHARACTER;
            }
        }
        this.tokenStart = this.tokenizer.startOffset;
        this.tokenEnd = this.tokenizer.endOffset;
    }

    public IElementType getTokenType() {
        if (this.firstCall) {
            this.advance();
        }
        return this.tokenType;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public void advance() {
        if (this.firstCall) {
            this.firstCall = false;
        }
        this.parseToken();
    }

    public CharSequence getBufferSequence() {
        return this.buffer;
    }

    public int getBufferEnd() {
        return this.endOffset;
    }

    public int getState() {
        return 0;
    }
}

