/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.hierarchy.type.SubtypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.SupertypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.type.TypeHierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.ui.PopupHandler;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeHierarchyBrowser
extends TypeHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.type.TypeHierarchyBrowser");

    public TypeHierarchyBrowser(Project project, PsiClass psiClass) {
        super(project, (PsiElement)psiClass);
    }

    @Override
    protected boolean isInterface(PsiElement psiElement) {
        return psiElement instanceof PsiClass && ((PsiClass)psiElement).isInterface();
    }

    @Override
    protected void createTrees(@NotNull Map<String, JTree> trees) {
        if (trees == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/hierarchy/type/TypeHierarchyBrowser.createTrees must not be null");
        }
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("TypeHierarchyPopupMenu");
        BaseOnThisTypeAction baseOnThisTypeAction = new BaseOnThisTypeAction();
        JTree tree1 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree1);
        trees.put(TYPE_HIERARCHY_TYPE, tree1);
        JTree tree2 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree2);
        trees.put(SUPERTYPES_HIERARCHY_TYPE, tree2);
        JTree tree3 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree3, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree3);
        trees.put(SUBTYPES_HIERARCHY_TYPE, tree3);
    }

    @Override
    protected void prependActions(DefaultActionGroup actionGroup) {
        super.prependActions(actionGroup);
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.ChangeScopeAction(){

            @Override
            protected boolean isEnabled() {
                return !Comparing.strEqual((String)TypeHierarchyBrowser.this.myCurrentViewType, (String)TypeHierarchyBrowserBase.SUPERTYPES_HIERARCHY_TYPE);
            }
        });
    }

    @Override
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/hierarchy/type/TypeHierarchyBrowser.getContentDisplayName must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/hierarchy/type/TypeHierarchyBrowser.getContentDisplayName must not be null");
        }
        return MessageFormat.format(typeName, ClassPresentationUtil.getNameForClass((PsiClass)element, false));
    }

    @Override
    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/hierarchy/type/TypeHierarchyBrowser.getElementFromDescriptor must not be null");
        }
        if (!(descriptor instanceof TypeHierarchyNodeDescriptor)) {
            return null;
        }
        return ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
    }

    @Override
    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    @Override
    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/hierarchy/type/TypeHierarchyBrowser.isApplicableElement must not be null");
        }
        return element instanceof PsiClass;
    }

    @Override
    protected Comparator<NodeDescriptor> getComparator() {
        return JavaHierarchyUtil.getComparator(this.myProject);
    }

    @Override
    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/hierarchy/type/TypeHierarchyBrowser.createHierarchyTreeStructure must not be null");
        }
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/hierarchy/type/TypeHierarchyBrowser.createHierarchyTreeStructure must not be null");
        }
        if (SUPERTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new SupertypesHierarchyTreeStructure(this.myProject, (PsiClass)psiElement);
        }
        if (SUBTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new SubtypesHierarchyTreeStructure(this.myProject, (PsiClass)psiElement, this.getCurrentScopeType());
        }
        if (TYPE_HIERARCHY_TYPE.equals(typeName)) {
            return new TypeHierarchyTreeStructure(this.myProject, (PsiClass)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    @Override
    protected boolean canBeDeleted(PsiElement psiElement) {
        return psiElement instanceof PsiClass && !(psiElement instanceof PsiAnonymousClass);
    }

    @Override
    protected String getQualifiedName(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            return ((PsiClass)psiElement).getQualifiedName();
        }
        return "";
    }

    public static class BaseOnThisTypeAction
    extends TypeHierarchyBrowserBase.BaseOnThisTypeAction {
        protected boolean isEnabled(TypeHierarchyBrowserBase browser, PsiElement psiElement) {
            return super.isEnabled(browser, psiElement) && !"java.lang.Object".equals(((PsiClass)psiElement).getQualifiedName());
        }
    }
}

