/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public final class CallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public CallerMethodsTreeStructure(Project project, PsiMethod method, String scopeType) {
        super(project, new CallHierarchyNodeDescriptor(project, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @Override
    protected final Object[] buildChildren(HierarchyNodeDescriptor descriptor) {
        PsiMember enclosingElement = ((CallHierarchyNodeDescriptor)descriptor).getEnclosingElement();
        if (!(enclosingElement instanceof PsiMethod)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        final PsiMethod method = (PsiMethod)enclosingElement;
        PsiMethod baseMethod = (PsiMethod)((CallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
        SearchScope searchScope = this.getSearchScope(this.myScopeType, (PsiElement)baseMethod.getContainingClass());
        final PsiClass originalClass = method.getContainingClass();
        assert (originalClass != null);
        final PsiClassType originalType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(originalClass);
        final HashSet<PsiMethod> methodsToFind = new HashSet<PsiMethod>();
        methodsToFind.add(method);
        methodsToFind.addAll(Arrays.asList(method.findDeepestSuperMethods()));
        HashMap methodToDescriptorMap = new HashMap();
        for (final PsiMethod methodToFind : methodsToFind) {
            MethodReferencesSearch.search((PsiMethod)methodToFind, (SearchScope)searchScope, (boolean)true).forEach((Processor)new Processor<PsiReference>((Map)methodToDescriptorMap, descriptor){
                final /* synthetic */ Map val$methodToDescriptorMap;
                final /* synthetic */ HierarchyNodeDescriptor val$descriptor;
                {
                    this.val$methodToDescriptorMap = map;
                    this.val$descriptor = hierarchyNodeDescriptor;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean process(PsiReference reference) {
                    if (reference instanceof PsiReferenceExpression) {
                        PsiMethod callee;
                        PsiClass psiClass;
                        PsiType qualifierType;
                        PsiClass superClass;
                        PsiExpression qualifier = ((PsiReferenceExpression)reference).getQualifierExpression();
                        if (qualifier instanceof PsiSuperExpression && originalClass.isInheritor(superClass = PsiUtil.resolveClassInType((PsiType)qualifier.getType()), true)) {
                            return true;
                        }
                        if (qualifier != null && !methodToFind.hasModifierProperty("static") && (qualifierType = qualifier.getType()) instanceof PsiClassType && !TypeConversionUtil.isAssignable((PsiType)qualifierType, (PsiType)originalType) && methodToFind != method && (psiClass = ((PsiClassType)qualifierType).resolve()) != null && (callee = psiClass.findMethodBySignature(methodToFind, true)) != null && !methodsToFind.contains(callee)) {
                            return true;
                        }
                    } else {
                        if (!(reference instanceof PsiElement)) {
                            return true;
                        }
                        PsiElement parent = ((PsiElement)reference).getParent();
                        if (parent instanceof PsiNewExpression) {
                            if (((PsiNewExpression)parent).getClassReference() != reference) {
                                return true;
                            }
                        } else if (parent instanceof PsiAnonymousClass) {
                            if (((PsiAnonymousClass)parent).getBaseClassReference() != reference) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                    }
                    PsiElement element = reference.getElement();
                    PsiMember key = CallHierarchyNodeDescriptor.getEnclosingElement(element);
                    Map map = this.val$methodToDescriptorMap;
                    synchronized (map) {
                        CallHierarchyNodeDescriptor d = (CallHierarchyNodeDescriptor)((Object)this.val$methodToDescriptorMap.get(key));
                        if (d == null) {
                            d = new CallHierarchyNodeDescriptor(CallerMethodsTreeStructure.this.myProject, this.val$descriptor, element, false, true);
                            this.val$methodToDescriptorMap.put(key, d);
                        } else if (!d.hasReference(reference)) {
                            d.incrementUsageCount();
                        }
                        d.addReference(reference);
                    }
                    return true;
                }
            });
        }
        return methodToDescriptorMap.values().toArray(new Object[methodToDescriptorMap.size()]);
    }

    @Override
    public boolean isAlwaysShowPlus() {
        return true;
    }
}

