/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

abstract class FileTemplateTabAsList
extends FileTemplateTab {
    private final JList myList = new JList();
    private MyListModel myModel;

    FileTemplateTabAsList(String title) {
        super(title);
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer(new MyListCellRenderer());
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FileTemplateTabAsList.this.onTemplateSelected();
            }
        });
    }

    @Override
    public void removeSelected() {
        FileTemplate selectedTemplate = this.getSelectedTemplate();
        if (selectedTemplate == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.myList.getModel();
        int selectedIndex = this.myList.getSelectedIndex();
        model.remove(selectedIndex);
        if (!model.isEmpty()) {
            this.myList.setSelectedIndex(Math.min(selectedIndex, model.size() - 1));
        }
        this.onTemplateSelected();
    }

    @Override
    protected void initSelection(FileTemplate selection) {
        FileTemplate[] templates;
        this.myModel = new MyListModel();
        this.myList.setModel(this.myModel);
        for (FileTemplate template : templates = this.savedTemplates.values().toArray(new FileTemplate[this.savedTemplates.values().size()])) {
            this.myModel.addElement(template);
        }
        if (selection != null) {
            this.selectTemplate(selection);
        } else if (this.myList.getModel().getSize() > 0) {
            this.myList.setSelectedIndex(0);
        }
    }

    @Override
    public void fireDataChanged() {
        this.myModel.fireListDataChanged();
    }

    @Override
    @NotNull
    public FileTemplate[] getTemplates() {
        int size = this.myModel.getSize();
        ArrayList<FileTemplate> templates = new ArrayList<FileTemplate>(size);
        for (int i = 0; i < size; ++i) {
            templates.add((FileTemplate)this.myModel.getElementAt(i));
        }
        FileTemplate[] fileTemplateArray = templates.toArray(new FileTemplate[templates.size()]);
        if (fileTemplateArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateTabAsList.getTemplates must not return null");
        }
        return fileTemplateArray;
    }

    @Override
    public void addTemplate(FileTemplate newTemplate) {
        this.myModel.addElement(newTemplate);
    }

    @Override
    public void selectTemplate(FileTemplate template) {
        this.myList.setSelectedValue(template, true);
    }

    @Override
    public FileTemplate getSelectedTemplate() {
        Object value = this.myList.getSelectedValue();
        return value instanceof FileTemplate ? (FileTemplate)value : null;
    }

    @Override
    public JComponent getComponent() {
        return this.myList;
    }

    private static class MyListModel
    extends DefaultListModel {
        private MyListModel() {
        }

        public void fireListDataChanged() {
            int size = this.getSize();
            if (size > 0) {
                this.fireContentsChanged(this, 0, size - 1);
            }
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = null;
            if (value instanceof FileTemplate) {
                FileTemplate template = (FileTemplate)value;
                icon = FileTypeManager.getInstance().getFileTypeByExtension(template.getExtension()).getIcon();
                boolean internalTemplate = AllFileTemplatesConfigurable.isInternalTemplate(template.getName(), FileTemplateTabAsList.this.getTitle());
                if (internalTemplate) {
                    this.setFont(this.getFont().deriveFont(1));
                    this.setText(FileTemplateManagerImpl.getInstanceImpl().localizeInternalTemplateName(template));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                    this.setText(template.getName());
                }
                if (!template.isDefault() && !isSelected) {
                    this.setForeground(FileTemplateTab.MODIFIED_FOREGROUND);
                }
            }
            this.setIcon(icon);
            return this;
        }
    }
}

