/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateTextLexer;
import com.intellij.ide.fileTemplates.impl.FileTemplateTokenType;
import com.intellij.lexer.CompositeLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateConfigurable
implements Configurable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable");
    @NonNls
    private static final String CONTENT_TYPE_HTML = "text/html";
    @NonNls
    private static final String EMPTY_HTML = "<html></html>";
    @NonNls
    private static final String CONTENT_TYPE_PLAIN = "text/plain";
    private JPanel myMainPanel;
    private FileTemplate myTemplate;
    private PsiFile myFile;
    private Editor myTemplateEditor;
    private JTextField myNameField;
    private JTextField myExtensionField;
    private JCheckBox myAdjustBox;
    private JPanel myTopPanel;
    private JEditorPane myDescriptionComponent;
    private boolean myModified = false;
    private String myDefaultDescriptionUrl;
    private final Project myProject = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
    private final ArrayList<ChangeListener> myChangeListeners = new ArrayList();
    private Splitter mySplitter;
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{FileTemplateTokenType.TEXT});

    public FileTemplate getTemplate() {
        return this.myTemplate;
    }

    public void setTemplate(FileTemplate template, VirtualFile defaultDescription) {
        this.myDefaultDescriptionUrl = defaultDescription == null ? null : defaultDescription.getUrl();
        this.myTemplate = template;
        this.reset();
        this.myNameField.selectAll();
        this.myExtensionField.selectAll();
    }

    public void setShowInternalMessage(String message) {
        if (message == null) {
            this.myTopPanel.removeAll();
            this.myTopPanel.add((Component)new JLabel(IdeBundle.message((String)"label.name", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
            this.myTopPanel.add((Component)this.myNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
            this.myTopPanel.add((Component)new JLabel(IdeBundle.message((String)"label.extension", (Object[])new Object[0])), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
            this.myTopPanel.add((Component)this.myExtensionField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
            this.myExtensionField.setColumns(7);
        } else {
            this.myTopPanel.removeAll();
            this.myTopPanel.add((Component)new JLabel(message), new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.myTopPanel.add(Box.createVerticalStrut(this.myNameField.getPreferredSize().height), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.myMainPanel.revalidate();
        this.myTopPanel.repaint();
    }

    public void setShowAdjustCheckBox(boolean show) {
        this.myAdjustBox.setEnabled(show);
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.file.templates", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myNameField = new JTextField();
        this.myExtensionField = new JTextField();
        this.mySplitter = new Splitter(true, 0.66f);
        this.myTemplateEditor = this.createEditor();
        this.myDescriptionComponent = new JEditorPane(CONTENT_TYPE_HTML, EMPTY_HTML);
        this.myDescriptionComponent.setEditable(false);
        this.myAdjustBox = new JCheckBox(IdeBundle.message((String)"checkbox.reformat.according.to.style", (Object[])new Object[0]));
        this.myTopPanel = new JPanel(new GridBagLayout());
        JPanel secondPanel = new JPanel(new GridBagLayout());
        secondPanel.add((Component)new JLabel(IdeBundle.message((String)"label.description", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        secondPanel.add((Component)new JScrollPane(this.myDescriptionComponent), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.myMainPanel.add((Component)this.myTopPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.myMainPanel.add((Component)this.myAdjustBox, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
        this.myMainPanel.add((Component)this.mySplitter, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.mySplitter.setSecondComponent((JComponent)secondPanel);
        this.setShowInternalMessage(null);
        this.myNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileTemplateConfigurable.this.onNameChanged();
            }
        });
        this.myExtensionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileTemplateConfigurable.this.onNameChanged();
            }
        });
        this.myMainPanel.setPreferredSize(new Dimension(400, 300));
        return this.myMainPanel;
    }

    private Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document doc = this.myFile == null ? editorFactory.createDocument((CharSequence)(this.myTemplate == null ? "" : this.myTemplate.getText())) : PsiDocumentManager.getInstance((Project)this.myFile.getProject()).getDocument(this.myFile);
        Editor editor = this.myProject == null ? editorFactory.createEditor(doc) : editorFactory.createEditor(doc, this.myProject);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(3);
        editorSettings.setAdditionalLinesCount(3);
        EditorColorsScheme scheme = editor.getColorsScheme();
        scheme.setColor(EditorColors.CARET_ROW_COLOR, null);
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                FileTemplateConfigurable.this.onTextChanged();
            }
        });
        ((EditorEx)editor).setHighlighter(this.createHighlighter());
        this.mySplitter.setFirstComponent(editor.getComponent());
        return editor;
    }

    private void onTextChanged() {
        this.myModified = true;
    }

    public String getNameValue() {
        return this.myNameField.getText();
    }

    public String getExtensionValue() {
        return this.myExtensionField.getText();
    }

    private void onNameChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : this.myChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.myChangeListeners.contains(listener)) {
            this.myChangeListeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myChangeListeners.remove(listener);
    }

    public boolean isModified() {
        String extension;
        if (this.myModified) {
            return true;
        }
        String name = this.myTemplate == null ? "" : this.myTemplate.getName();
        String string = extension = this.myTemplate == null ? "" : this.myTemplate.getExtension();
        if (!Comparing.equal((String)name, (String)this.myNameField.getText())) {
            return true;
        }
        if (!Comparing.equal((String)extension, (String)this.myExtensionField.getText())) {
            return true;
        }
        return this.myTemplate != null && this.myTemplate.isAdjust() != this.myAdjustBox.isSelected();
    }

    public void apply() throws ConfigurationException {
        if (this.myTemplate != null) {
            this.myTemplate.setText(this.myTemplateEditor.getDocument().getText());
            String name = this.myNameField.getText();
            String extension = this.myExtensionField.getText();
            int lastDotIndex = extension.lastIndexOf(".");
            if (lastDotIndex >= 0) {
                name = name + extension.substring(0, lastDotIndex + 1);
                extension = extension.substring(lastDotIndex + 1);
            }
            if (name.length() == 0 || !FileTemplateConfigurable.isValidFilename(name + "." + extension)) {
                throw new ConfigurationException(IdeBundle.message((String)"error.invalid.template.file.name.or.extension", (Object[])new Object[0]));
            }
            this.myTemplate.setName(name);
            this.myTemplate.setExtension(extension);
            this.myTemplate.setAdjust(this.myAdjustBox.isSelected());
        }
        this.myModified = false;
    }

    private static boolean isValidFilename(String filename) {
        if (filename.contains("/") || filename.contains("\\") || filename.contains(":")) {
            return false;
        }
        File tempFile = new File(FileUtil.getTempDirectory() + File.separator + filename);
        return FileUtil.ensureCanCreateFile((File)tempFile);
    }

    public void reset() {
        String description;
        String text = this.myTemplate == null ? "" : this.myTemplate.getText();
        String name = this.myTemplate == null ? "" : this.myTemplate.getName();
        String extension = this.myTemplate == null ? "" : this.myTemplate.getExtension();
        String string = description = this.myTemplate == null ? "" : this.myTemplate.getDescription();
        if (description.length() == 0 && this.myDefaultDescriptionUrl != null) {
            try {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(this.myDefaultDescriptionUrl);
                if (file != null) {
                    description = VfsUtil.loadText((VirtualFile)file);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
        this.myFile = this.createFile(text, name);
        this.myTemplateEditor = this.createEditor();
        boolean adjust = this.myTemplate != null && this.myTemplate.isAdjust();
        this.myNameField.setText(name);
        this.myExtensionField.setText(extension);
        this.myAdjustBox.setSelected(adjust);
        String desc = description.length() > 0 ? description : EMPTY_HTML;
        this.myDescriptionComponent.setContentType(CONTENT_TYPE_PLAIN);
        this.myDescriptionComponent.setEditable(true);
        this.myDescriptionComponent.setText(desc);
        this.myDescriptionComponent.setContentType(CONTENT_TYPE_HTML);
        this.myDescriptionComponent.setText(desc);
        this.myDescriptionComponent.setCaretPosition(0);
        this.myDescriptionComponent.setEditable(false);
        this.myNameField.setEditable(this.myTemplate != null && !this.myTemplate.isDefault());
        this.myExtensionField.setEditable(this.myTemplate != null && !this.myTemplate.isDefault());
        this.myModified = false;
    }

    @Nullable
    private PsiFile createFile(String text, String name) {
        if (this.myTemplate == null || this.myProject == null) {
            return null;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension("ft");
        if (fileType == FileTypes.UNKNOWN) {
            return null;
        }
        PsiFile file = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(name + ".txt.ft", fileType, (CharSequence)text, 0L, true);
        file.getViewProvider().putUserData(FileTemplateManager.DEFAULT_TEMPLATE_PROPERTIES, (Object)FileTemplateManager.getInstance().getDefaultProperties());
        return file;
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
        if (this.myTemplateEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
            this.myTemplateEditor = null;
        }
        this.myFile = null;
    }

    private EditorHighlighter createHighlighter() {
        SyntaxHighlighter originalHighlighter;
        if (this.myTemplate != null && this.myProject != null) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)new LightVirtualFile("aaa." + this.myTemplate.getExtension() + ".ft"));
        }
        LanguageFileType fileType = null;
        if (this.myTemplate != null) {
            fileType = FileTypeManager.getInstance().getFileTypeByExtension(this.myTemplate.getExtension());
        }
        if (fileType == null) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        if ((originalHighlighter = SyntaxHighlighter.PROVIDER.create((FileType)fileType, null, null)) == null) {
            originalHighlighter = new PlainSyntaxHighlighter();
        }
        return new LexerEditorHighlighter((SyntaxHighlighter)new TemplateHighlighter(originalHighlighter), EditorColorsManager.getInstance().getGlobalScheme());
    }

    public void focusToNameField() {
        this.myNameField.selectAll();
        this.myNameField.requestFocus();
    }

    public void focusToExtensionField() {
        this.myExtensionField.selectAll();
        this.myExtensionField.requestFocus();
    }

    private static class TemplateHighlighter
    extends SyntaxHighlighterBase {
        private final Lexer myLexer;
        private final SyntaxHighlighter myOriginalHighlighter;

        public TemplateHighlighter(SyntaxHighlighter original) {
            this.myOriginalHighlighter = original;
            Lexer originalLexer = original.getHighlightingLexer();
            FlexAdapter templateLexer = new FlexAdapter((FlexLexer)new FileTemplateTextLexer());
            templateLexer = new MergingLexerAdapter((Lexer)templateLexer, TOKENS_TO_MERGE);
            this.myLexer = new CompositeLexer(originalLexer, (Lexer)templateLexer){

                protected IElementType getCompositeTokenType(IElementType type1, IElementType type2) {
                    if (type2 == FileTemplateTokenType.MACRO || type2 == FileTemplateTokenType.DIRECTIVE) {
                        return type2;
                    }
                    return type1;
                }
            };
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            Lexer lexer = this.myLexer;
            if (lexer == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$TemplateHighlighter.getHighlightingLexer must not return null");
            }
            return lexer;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            TextAttributesKey[] textAttributesKeyArray;
            if (tokenType == FileTemplateTokenType.MACRO) {
                textAttributesKeyArray = TemplateHighlighter.pack((TextAttributesKey[])this.myOriginalHighlighter.getTokenHighlights(tokenType), (TextAttributesKey)TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES);
                if (textAttributesKeyArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$TemplateHighlighter.getTokenHighlights must not return null");
                return textAttributesKeyArray;
            }
            if (tokenType == FileTemplateTokenType.DIRECTIVE) {
                textAttributesKeyArray = TemplateHighlighter.pack((TextAttributesKey[])this.myOriginalHighlighter.getTokenHighlights(tokenType), (TextAttributesKey)TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES);
                if (textAttributesKeyArray == null) throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$TemplateHighlighter.getTokenHighlights must not return null");
                return textAttributesKeyArray;
            }
            textAttributesKeyArray = this.myOriginalHighlighter.getTokenHighlights(tokenType);
            if (textAttributesKeyArray != null) return textAttributesKeyArray;
            throw new IllegalStateException("@NotNull method com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$TemplateHighlighter.getTokenHighlights must not return null");
        }
    }
}

