/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;

public class AddAllOpenFilesToFavorites
extends AnAction {
    private final String myFavoritesName;

    public AddAllOpenFilesToFavorites(String choosenList) {
        super(choosenList);
        this.myFavoritesName = choosenList;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        ArrayList<PsiFile> filesToAdd = AddAllOpenFilesToFavorites.getFilesToAdd(project);
        for (PsiFile file : filesToAdd) {
            favoritesManager.addRoots(this.myFavoritesName, null, file);
        }
    }

    static ArrayList<PsiFile> getFilesToAdd(Project project) {
        VirtualFile[] openFiles;
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
            PsiFile psiFile = psiManager.findFile(openFile);
            if (psiFile == null) continue;
            result.add(psiFile);
        }
        return result;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(!AddAllOpenFilesToFavorites.getFilesToAdd(project).isEmpty());
    }
}

