/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeStructure;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesTreeViewPanel
extends JPanel
implements DataProvider {
    @NonNls
    public static final String ABSTRACT_TREE_NODE_TRANSFERABLE = "AbstractTransferable";
    private final FavoritesTreeStructure myFavoritesTreeStructure;
    private FavoritesViewTreeBuilder myBuilder;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private MouseListener myTreePopupHandler;
    public static final DataKey<FavoritesTreeNodeDescriptor[]> CONTEXT_FAVORITES_ROOTS_DATA_KEY = DataKey.create((String)"FavoritesRoot");
    @Deprecated
    public static final String CONTEXT_FAVORITES_ROOTS = CONTEXT_FAVORITES_ROOTS_DATA_KEY.getName();
    public static final DataKey<String> FAVORITES_LIST_NAME_DATA_KEY = DataKey.create((String)"FavoritesListName");
    @Deprecated
    public static final String FAVORITES_LIST_NAME = FAVORITES_LIST_NAME_DATA_KEY.getName();
    protected Project myProject;
    private final String myHelpId;
    protected DnDAwareTree myTree;
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();
    private final ModuleDeleteProvider myDeleteModuleProvider = new ModuleDeleteProvider();
    private String myListName;
    private final IdeView myIdeView = new MyIdeView();

    public FavoritesTreeViewPanel(Project project, String helpId, String name) {
        super(new BorderLayout());
        this.myProject = project;
        this.myHelpId = helpId;
        this.myListName = name;
        this.myFavoritesTreeStructure = new FavoritesTreeStructure(project, this.myListName);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject(this.myFavoritesTreeStructure.getRootElement());
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.myTree = new DnDAwareTree(treeModel);
        this.myBuilder = new FavoritesViewTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, this.myFavoritesTreeStructure, this.myListName);
        TreeUtil.installActions((JTree)((Object)this.myTree));
        UIUtil.setLineStyleAngled((JTree)((Object)this.myTree));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        new TreeSpeedSearch((JTree)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        TreeToolTipHandler.install((JTree)((Object)this.myTree));
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object userObject;
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
                    String location;
                    FavoritesTreeNodeDescriptor favoritesTreeNodeDescriptor = (FavoritesTreeNodeDescriptor)((Object)userObject);
                    AbstractTreeNode treeNode = favoritesTreeNodeDescriptor.getElement();
                    PresentationData presentation = treeNode.getPresentation();
                    String locationString = presentation.getLocationString();
                    if (locationString != null && locationString.length() > 0) {
                        this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    } else if (node.getParent() != null && node.getParent().getParent() == null && (location = favoritesTreeNodeDescriptor.getLocation()) != null && location.length() > 0) {
                        this.append(" (" + location + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)((Object)this.myTree));
        this.myTreePopupHandler = CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "FavoritesViewPopupMenu", "FavoritesPopup");
        this.add((Component)scrollPane, "Center");
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this.myTree));
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                PsiElement[] psiElementArray = FavoritesTreeViewPanel.this.getSelectedPsiElements();
                if (psiElementArray == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel$2.getSelectedElements must not return null");
                }
                return psiElementArray;
            }
        };
    }

    public void selectElement(Object selector, VirtualFile file, boolean requestFocus) {
        this.myBuilder.select(selector, file, requestFocus);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myBuilder);
        this.myBuilder = null;
    }

    public DnDAwareTree getTree() {
        return this.myTree;
    }

    @Override
    public String getName() {
        return this.myListName;
    }

    @Override
    public void setName(String name) {
        this.myListName = name;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private PsiElement[] getSelectedPsiElements() {
        PsiElement[] psiElementArray;
        Object[] elements = this.getSelectedNodeElements();
        if (elements == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel.getSelectedPsiElements must not return null");
            return psiElementArray;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        Object[] arr$ = elements;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block9: {
                int len$2;
                FavoriteNodeProvider[] arr$2;
                Object element;
                block11: {
                    block7: {
                        block10: {
                            block8: {
                                if (i$ >= len$) break block7;
                                element = arr$[i$];
                                if (!(element instanceof PsiElement)) break block8;
                                result.add((PsiElement)element);
                                break block9;
                            }
                            if (!(element instanceof SmartPsiElementPointer)) break block10;
                            PsiElement psiElement = ((SmartPsiElementPointer)element).getElement();
                            if (psiElement == null) break block9;
                            result.add(psiElement);
                            break block9;
                        }
                        arr$2 = (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject);
                        len$2 = arr$2.length;
                        break block11;
                    }
                    psiElementArray = result.toArray(new PsiElement[result.size()]);
                    if (psiElementArray != null) return psiElementArray;
                    throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel.getSelectedPsiElements must not return null");
                }
                for (int i$2 = 0; i$2 < len$2; ++i$2) {
                    FavoriteNodeProvider provider = arr$2[i$2];
                    PsiElement psiElement = provider.getPsiElement(element);
                    if (psiElement == null) continue;
                    result.add(psiElement);
                    break;
                }
            }
            ++i$;
        }
    }

    public FavoritesTreeStructure getFavoritesTreeStructure() {
        return this.myFavoritesTreeStructure;
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            FavoritesTreeNodeDescriptor[] selectedNodeDescriptors = this.getSelectedNodeDescriptors();
            return selectedNodeDescriptors.length == 1 ? selectedNodeDescriptors[0].getElement() : null;
        }
        if (PlatformDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<Navigatable> selectedElements = this.getSelectedElements(Navigatable.class);
            return selectedElements.toArray(new Navigatable[selectedElements.size()]);
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        if (LangDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement[] elements = this.getSelectedPsiElements();
            if (elements.length != 1) {
                return null;
            }
            return elements[0] != null && elements[0].isValid() ? elements[0] : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] elements = this.getSelectedPsiElements();
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (PsiElement element : elements) {
                if (!element.isValid()) continue;
                result.add(element);
            }
            return result.isEmpty() ? null : result.toArray(new PsiElement[result.size()]);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            Module[] selected = this.getSelectedModules();
            return selected != null && selected.length == 1 ? selected[0] : null;
        }
        if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
            return this.getSelectedModules();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            Object[] elements = this.getSelectedNodeElements();
            return elements != null && elements.length >= 1 && elements[0] instanceof Module ? this.myDeleteModuleProvider : this.myDeletePSIElementProvider;
        }
        if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
            List<ModuleGroup> selectedElements = this.getSelectedElements(ModuleGroup.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[selectedElements.size()]);
        }
        if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
            List<LibraryGroupElement> selectedElements = this.getSelectedElements(LibraryGroupElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[selectedElements.size()]);
        }
        if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
            List<NamedLibraryElement> selectedElements = this.getSelectedElements(NamedLibraryElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[selectedElements.size()]);
        }
        if (CONTEXT_FAVORITES_ROOTS_DATA_KEY.is(dataId)) {
            FavoritesTreeNodeDescriptor[] selectedNodeDescriptors;
            ArrayList<FavoritesTreeNodeDescriptor> result = new ArrayList<FavoritesTreeNodeDescriptor>();
            for (FavoritesTreeNodeDescriptor selectedNodeDescriptor : selectedNodeDescriptors = this.getSelectedNodeDescriptors()) {
                FavoritesTreeNodeDescriptor root = selectedNodeDescriptor.getFavoritesRoot();
                if (root == null || root.getElement().getValue() instanceof String) continue;
                result.add(root);
            }
            return result.toArray(new FavoritesTreeNodeDescriptor[result.size()]);
        }
        if (FAVORITES_LIST_NAME_DATA_KEY.is(dataId)) {
            return this.myListName;
        }
        FavoritesTreeNodeDescriptor[] descriptors = this.getSelectedNodeDescriptors();
        if (descriptors.length > 0) {
            ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
            for (FavoritesTreeNodeDescriptor descriptor : descriptors) {
                nodes.add(descriptor.getElement());
            }
            return this.myFavoritesTreeStructure.getDataFromProviders(nodes, dataId);
        }
        return null;
    }

    private <T> List<T> getSelectedElements(Class<T> klass) {
        Object[] elements = this.getSelectedNodeElements();
        ArrayList<Object> result = new ArrayList<Object>();
        if (elements == null) {
            return result;
        }
        for (Object element : elements) {
            if (element == null || !klass.isAssignableFrom(element.getClass())) continue;
            result.add(element);
        }
        return result;
    }

    private Module[] getSelectedModules() {
        Object[] elements = this.getSelectedNodeElements();
        if (elements == null) {
            return null;
        }
        ArrayList<Module> result = new ArrayList<Module>();
        for (Object element : elements) {
            if (element instanceof Module) {
                result.add((Module)element);
                continue;
            }
            if (!(element instanceof ModuleGroup)) continue;
            result.addAll(((ModuleGroup)element).modulesInGroup(this.myProject, true));
        }
        return result.isEmpty() ? null : result.toArray(new Module[result.size()]);
    }

    private Object[] getSelectedNodeElements() {
        FavoritesTreeNodeDescriptor[] selectedNodeDescriptors = this.getSelectedNodeDescriptors();
        ArrayList<Object> result = new ArrayList<Object>();
        for (FavoritesTreeNodeDescriptor selectedNodeDescriptor : selectedNodeDescriptors) {
            if (selectedNodeDescriptor == null) continue;
            Object value = selectedNodeDescriptor.getElement().getValue();
            if (value instanceof SmartPsiElementPointer) {
                value = ((SmartPsiElementPointer)value).getElement();
            }
            result.add(value);
        }
        return ArrayUtil.toObjectArray(result);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FavoritesTreeNodeDescriptor[] getSelectedNodeDescriptors() {
        FavoritesTreeNodeDescriptor[] favoritesTreeNodeDescriptorArray;
        TreePath[] path = this.myTree.getSelectionPaths();
        if (path == null) {
            favoritesTreeNodeDescriptorArray = FavoritesTreeNodeDescriptor.EMPTY_ARRAY;
            if (FavoritesTreeNodeDescriptor.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel.getSelectedNodeDescriptors must not return null");
            return favoritesTreeNodeDescriptorArray;
        }
        ArrayList<FavoritesTreeNodeDescriptor> result = new ArrayList<FavoritesTreeNodeDescriptor>();
        for (TreePath treePath : path) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof FavoritesTreeNodeDescriptor)) continue;
            FavoritesTreeNodeDescriptor treeNodeDescriptor = (FavoritesTreeNodeDescriptor)((Object)userObject);
            result.add(treeNodeDescriptor);
        }
        favoritesTreeNodeDescriptorArray = result.toArray(new FavoritesTreeNodeDescriptor[result.size()]);
        if (favoritesTreeNodeDescriptorArray != null) return favoritesTreeNodeDescriptorArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel.getSelectedNodeDescriptors must not return null");
    }

    public static String getQualifiedName(VirtualFile file) {
        return file.getPresentableUrl();
    }

    public FavoritesViewTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            if (element != null) {
                Editor editor;
                this.selectPsiElement(element, false);
                boolean requestFocus = true;
                boolean isDirectory = element instanceof PsiDirectory;
                if (!isDirectory && (editor = EditorHelper.openInEditor(element)) != null) {
                    ToolWindowManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).activateEditorComponent();
                    requestFocus = false;
                }
                if (requestFocus) {
                    this.selectPsiElement(element, true);
                }
            }
        }

        private void selectPsiElement(PsiElement element, boolean requestFocus) {
            VirtualFile virtualFile = PsiUtilBase.getVirtualFile((PsiElement)element);
            FavoritesTreeViewPanel.this.selectElement(element, virtualFile, requestFocus);
        }

        @Nullable
        private PsiDirectory[] getSelectedDirectories() {
            PsiDirectory[] psiDirectoryArray;
            if (FavoritesTreeViewPanel.this.myBuilder == null) {
                return null;
            }
            Object[] selectedNodeElements = FavoritesTreeViewPanel.this.getSelectedNodeElements();
            if (selectedNodeElements.length != 1) {
                return null;
            }
            for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)FavoritesTreeViewPanel.this.myProject)) {
                Module module;
                PsiElement psiElement = nodeProvider.getPsiElement(selectedNodeElements[0]);
                if (psiElement instanceof PsiDirectory) {
                    return new PsiDirectory[]{(PsiDirectory)psiElement};
                }
                if (!(psiElement instanceof PsiDirectoryContainer)) continue;
                String moduleName = nodeProvider.getElementModuleName(selectedNodeElements[0]);
                GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)FavoritesTreeViewPanel.this.myProject);
                if (moduleName != null && (module = ModuleManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).findModuleByName(moduleName)) != null) {
                    searchScope = GlobalSearchScope.moduleScope((Module)module);
                }
                return ((PsiDirectoryContainer)psiElement).getDirectories(searchScope);
            }
            if (selectedNodeElements[0] instanceof PsiDirectory) {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = (PsiDirectory)selectedNodeElements[0];
            } else {
                psiDirectoryArray = null;
            }
            return psiDirectoryArray;
        }

        public PsiDirectory[] getDirectories() {
            PsiDirectory[] directories = this.getSelectedDirectories();
            return directories == null ? PsiDirectory.EMPTY_ARRAY : directories;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(DataContext dataContext) {
            PsiElement[] elements = this.getElementsToDelete();
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(DataContext dataContext) {
            List<PsiElement> allElements = Arrays.asList(this.getElementsToDelete());
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = validElements.toArray(new PsiElement[validElements.size()]);
            LocalHistoryAction a = LocalHistory.startAction((Project)FavoritesTreeViewPanel.this.myProject, (String)IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, FavoritesTreeViewPanel.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        private PsiElement[] getElementsToDelete() {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            Object[] elements = FavoritesTreeViewPanel.this.getSelectedNodeElements();
            for (int idx = 0; elements != null && idx < elements.length; ++idx) {
                PsiFile psiFile;
                VirtualFile vFile;
                VirtualFile virtualFile;
                String path;
                if (!(elements[idx] instanceof PsiElement)) continue;
                PsiElement element = (PsiElement)elements[idx];
                result.add(element);
                if (!(element instanceof PsiDirectory) || !(path = (virtualFile = ((PsiDirectory)element).getVirtualFile()).getPath()).endsWith("!/") || (vFile = LocalFileSystem.getInstance().findFileByPath(path.substring(0, path.length() - "!/".length()))) == null || (psiFile = PsiManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).findFile(vFile)) == null) continue;
                elements[idx] = psiFile;
            }
            return result.toArray(new PsiElement[result.size()]);
        }
    }
}

