/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.ide.bookmarks.actions.MnemonicChooser;
import com.intellij.ide.bookmarks.actions.ToggleBookmarkAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import javax.swing.JComponent;

public class ToggleBookmarkWithMnemonicAction
extends ToggleBookmarkAction {
    public ToggleBookmarkWithMnemonicAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"action.toggle.bookmark.mnemonic", (Object[])new Object[0]));
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        super.actionPerformed(e);
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        BookmarksAction.BookmarkInContextInfo info = new BookmarksAction.BookmarkInContextInfo(dataContext, project).invoke();
        final Bookmark bookmark = info.getBookmarkAtPlace();
        final BookmarkManager bookmarks = BookmarkManager.getInstance(project);
        if (bookmark != null) {
            final JBPopup[] popup = new JBPopup[1];
            MnemonicChooser mc = new MnemonicChooser(){

                @Override
                protected void onMnemonicChosen(char c) {
                    popup[0].cancel();
                    bookmarks.setMnemonic(bookmark, c);
                }

                @Override
                protected void onCancelled() {
                    popup[0].cancel();
                    bookmarks.removeBookmark(bookmark);
                }

                @Override
                protected boolean isOccupied(char c) {
                    return bookmarks.findBookmarkForMnemonic(c) != null;
                }
            };
            ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)mc, (JComponent)mc);
            popup[0] = builder.setTitle("Bookmark Mnemonic").setFocusable(true).setRequestFocus(true).setMovable(false).setCancelKeyEnabled(false).setAdText(bookmarks.hasBookmarksWithMnemonics() ? "Yellow cells in use" : null).setResizable(false).createPopup();
            popup[0].showInBestPositionFor(dataContext);
        }
    }

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        event.getPresentation().setText(IdeBundle.message((String)"action.toggle.bookmark.mnemonic", (Object[])new Object[0]));
    }
}

