/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.FileStructureDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewStructureAction
extends AnAction {
    public ViewStructureAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (editor == null) {
            return;
        }
        if (fileEditor == null) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.file.structure");
        Navigatable navigatable = (Navigatable)e.getData(PlatformDataKeys.NAVIGATABLE);
        DialogWrapper dialog = ViewStructureAction.createDialog(editor, project, navigatable, fileEditor);
        if (dialog != null) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                dialog.setTitle(virtualFile.getPresentableUrl());
            }
            dialog.show();
        }
    }

    @Nullable
    private static DialogWrapper createDialog(Editor editor, Project project, Navigatable navigatable, FileEditor fileEditor) {
        StructureViewBuilder structureViewBuilder = fileEditor.getStructureViewBuilder();
        if (structureViewBuilder == null) {
            return null;
        }
        StructureView structureView = structureViewBuilder.createStructureView(fileEditor, project);
        return ViewStructureAction.createStructureViewBasedDialog(structureView.getTreeModel(), editor, project, navigatable, (Disposable)structureView);
    }

    public static FileStructureDialog createStructureViewBasedDialog(StructureViewModel structureViewModel, Editor editor, Project project, Navigatable navigatable, @NotNull Disposable alternativeDisposable) {
        if (alternativeDisposable == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/ide/actions/ViewStructureAction.createStructureViewBasedDialog must not be null");
        }
        return new FileStructureDialog(structureViewModel, editor, project, navigatable, alternativeDisposable, true);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            presentation.setEnabled(false);
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(StructureViewBuilder.PROVIDER.getStructureViewBuilder(virtualFile.getFileType(), virtualFile, project) != null);
    }
}

