/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenProcessorBase;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;

public class OpenProjectAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        String home;
        ProjectOpenProcessor[] openProcessors;
        Project project = (Project)PlatformDataKeys.PROJECT.getData(e.getDataContext());
        OpenProjectFileChooserDescriptor descriptor = new OpenProjectFileChooserDescriptor(true);
        descriptor.setTitle(IdeBundle.message((String)"title.open.project", (Object[])new Object[0]));
        HashSet<String> extensions = new HashSet<String>();
        extensions.add(".ipr");
        for (ProjectOpenProcessor openProcessor : openProcessors = (ProjectOpenProcessor[])Extensions.getExtensions((ExtensionPointName)ProjectOpenProcessorBase.EXTENSION_POINT_NAME)) {
            String[] supportedExtensions = ((ProjectOpenProcessorBase)openProcessor).getSupportedExtensions();
            if (supportedExtensions == null) continue;
            Collections.addAll(extensions, supportedExtensions);
        }
        descriptor.setDescription(IdeBundle.message((String)"filter.project.files", (Object[])new Object[]{StringUtil.join(extensions, (String)", ")}));
        VirtualFile userHomeDir = null;
        if ((SystemInfo.isMac || SystemInfo.isLinux) && (home = System.getProperty("user.home")) != null) {
            userHomeDir = LocalFileSystem.getInstance().findFileByIoFile(new File(home));
        }
        descriptor.putUserData(FileChooserDialogImpl.PREFER_LAST_OVER_TO_SELECT, Boolean.TRUE);
        VirtualFile[] files = FileChooser.chooseFiles((Project)project, (FileChooserDescriptor)descriptor, userHomeDir);
        if (files.length == 0 || files[0] == null) {
            return;
        }
        ProjectUtil.openOrImport(files[0].getPath(), project, false);
    }
}

