/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;

public abstract class GotoActionBase
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.actions.GotoActionBase");
    protected static Class myInAction = null;

    public final void actionPerformed(AnActionEvent e) {
        LOG.assertTrue(!((Object)((Object)this)).getClass().equals(myInAction));
        try {
            myInAction = ((Object)((Object)this)).getClass();
            this.gotoActionPerformed(e);
        }
        catch (Throwable t) {
            LOG.error(t);
            myInAction = null;
        }
    }

    protected abstract void gotoActionPerformed(AnActionEvent var1);

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        presentation.setEnabled(!((Object)((Object)this)).getClass().equals(myInAction) && project != null && this.hasContributors(dataContext));
        presentation.setVisible(this.hasContributors(dataContext));
    }

    protected boolean hasContributors(DataContext dataContext) {
        return true;
    }

    public static PsiElement getPsiContext(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (file != null) {
            return file;
        }
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        return GotoActionBase.getPsiContext(project);
    }

    public static PsiElement getPsiContext(Project project) {
        if (project == null) {
            return null;
        }
        Editor selectedEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (selectedEditor == null) {
            return null;
        }
        Document document = selectedEditor.getDocument();
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
    }
}

