/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.util.ExportToFileUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;

public class ExportToTextFileAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        ExporterToTextFile exporterToTextFile = this.getExporter(dataContext);
        if (project == null || exporterToTextFile == null) {
            return;
        }
        if (!exporterToTextFile.canExport()) {
            return;
        }
        ExportToTextFileAction.export(project, exporterToTextFile);
    }

    public static void export(Project project, ExporterToTextFile exporter) {
        ExportToFileUtil.ExportDialogBase dlg = new ExportToFileUtil.ExportDialogBase(project, exporter);
        dlg.show();
        if (!dlg.isOK()) {
            return;
        }
        ExportToFileUtil.exportTextToFile(project, dlg.getFileName(), dlg.getText());
        exporter.exportedTo(dlg.getFileName());
    }

    protected ExporterToTextFile getExporter(DataContext dataContext) {
        return (ExporterToTextFile)PlatformDataKeys.EXPORTER_TO_TEXT_FILE.getData(dataContext);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        ExporterToTextFile exporterToTextFile = this.getExporter(dataContext);
        presentation.setEnabled(PlatformDataKeys.PROJECT.getData(dataContext) != null && exporterToTextFile != null && exporterToTextFile.canExport());
    }
}

