/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.net.ServerSocket;
import org.apache.xmlrpc.IdeaAwareWebServer;
import org.apache.xmlrpc.IdeaAwareXmlRpcServer;
import org.apache.xmlrpc.WebServer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlRpcServerImpl
implements XmlRpcServer,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.XmlRpcServerImpl");
    private static final int FIRST_PORT_NUMBER = 63342;
    private static final int PORTS_COUNT = 20;
    public static int detectedPortNumber = -1;
    private WebServer myWebServer;
    @NonNls
    private static final String PROPERTY_RPC_PORT = "rpc.port";

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("XmlRpcServer" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/XmlRpcServerImpl.getComponentName must not return null");
        }
        return "XmlRpcServer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode() || !XmlRpcServerImpl.checkPort()) {
            return;
        }
        Thread thread = Thread.currentThread();
        int currentPriority = thread.getPriority();
        try {
            thread.setPriority(3);
            this.myWebServer = new IdeaAwareWebServer(this.getPortNumber(), null, new IdeaAwareXmlRpcServer());
            this.myWebServer.start();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            this.myWebServer = null;
        }
        finally {
            thread.setPriority(currentPriority);
        }
    }

    public int getPortNumber() {
        return detectedPortNumber == -1 ? XmlRpcServerImpl.getDefaultPort() : detectedPortNumber;
    }

    private static int getDefaultPort() {
        if (System.getProperty(PROPERTY_RPC_PORT) != null) {
            return Integer.parseInt(System.getProperty(PROPERTY_RPC_PORT));
        }
        return 63342;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean checkPort() {
        block20: {
            int i;
            ServerSocket socket = null;
            int firstPort = XmlRpcServerImpl.getDefaultPort();
            for (i = 0; i < 20; ++i) {
                int port = firstPort + i;
                try {
                    socket = new ServerSocket(port);
                    detectedPortNumber = port;
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ignored) {
                    continue;
                }
            }
            socket = new ServerSocket(0);
            detectedPortNumber = socket.getLocalPort();
            i = 1;
            return i != 0;
            catch (IOException iOException) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                break block20;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    public void disposeComponent() {
        if (this.myWebServer != null) {
            this.myWebServer.shutdown();
        }
    }

    public void addHandler(String name, Object handler) {
        if (this.myWebServer != null) {
            this.myWebServer.addHandler(name, handler);
        } else {
            LOG.info("Handler not registered because XML-RPC server is not running");
        }
    }

    public void removeHandler(String name) {
        if (this.myWebServer != null) {
            this.myWebServer.removeHandler(name);
        }
    }
}

