/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.PsiElement;
import java.awt.datatransfer.Transferable;

public class CopyPasteUtil {
    private CopyPasteUtil() {
    }

    public static PsiElement[] getElementsInTransferable(Transferable t) {
        PsiElement[] elts = PsiCopyPasteManager.getElements(t);
        return elts != null ? elts : PsiElement.EMPTY_ARRAY;
    }

    public static class DefaultCopyPasteListener
    implements CopyPasteManager.ContentChangedListener {
        private final AbstractTreeUpdater myUpdater;

        public DefaultCopyPasteListener(AbstractTreeUpdater updater) {
            this.myUpdater = updater;
        }

        public void contentChanged(Transferable oldTransferable, Transferable newTransferable) {
            this.updateByTransferable(oldTransferable);
            this.updateByTransferable(newTransferable);
        }

        private void updateByTransferable(Transferable t) {
            PsiElement[] psiElements;
            for (PsiElement psiElement : psiElements = CopyPasteUtil.getElementsInTransferable(t)) {
                this.myUpdater.addSubtreeToUpdateByElement((Object)psiElement);
            }
        }
    }
}

