/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BrowserSettingsProvider;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BrowserSettingsPanel
extends JPanel {
    private final JRadioButton myUseDefaultBrowser;
    private final JRadioButton myUseAlternativeBrowser;
    private final BrowserSettingsProvider[] mySettingsProviders;
    private final TextFieldWithBrowseButton myBrowserPathField;
    private final JCheckBox myConfirmExtractFiles;
    private final JButton myClearExtractedFiles;

    public BrowserSettingsPanel() {
        this.setLayout(new BorderLayout());
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        JPanel genericPanel = new JPanel();
        genericPanel.setBorder(BorderFactory.createTitledBorder("Default Web Browser"));
        genericPanel.setLayout(new BoxLayout(genericPanel, 1));
        JPanel innerPanel1 = new JPanel(new BorderLayout());
        ButtonGroup group = new ButtonGroup();
        this.myUseDefaultBrowser = new JRadioButton("Use system default browser");
        group.add(this.myUseDefaultBrowser);
        innerPanel1.add((Component)this.myUseDefaultBrowser, "West");
        genericPanel.add(innerPanel1);
        JPanel innerPanel2 = new JPanel(new BorderLayout());
        this.myUseAlternativeBrowser = new JRadioButton("Use");
        group.add(this.myUseAlternativeBrowser);
        innerPanel2.add((Component)this.myUseAlternativeBrowser, "West");
        this.myBrowserPathField = new TextFieldWithBrowseButton();
        innerPanel2.add((Component)this.myBrowserPathField, "Center");
        genericPanel.add(innerPanel2);
        JPanel innerPanel3 = new JPanel(new BorderLayout());
        this.myConfirmExtractFiles = new JCheckBox("Show confirmation before extracting files");
        this.myClearExtractedFiles = new JButton("Clear extracted files");
        this.myClearExtractedFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.clearExtractedFiles();
            }
        });
        innerPanel3.add((Component)this.myConfirmExtractFiles, "Center");
        innerPanel3.add((Component)this.myClearExtractedFiles, "East");
        genericPanel.add(innerPanel3);
        outerPanel.add(genericPanel);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        this.myBrowserPathField.addBrowseFolderListener(IdeBundle.message((String)"title.select.path.to.browser", (Object[])new Object[0]), null, null, descriptor);
        if (BrowserUtil.canStartDefaultBrowser()) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowserSettingsPanel.this.updateBrowserField();
                }
            };
            this.myUseDefaultBrowser.addActionListener(actionListener);
            this.myUseAlternativeBrowser.addActionListener(actionListener);
        } else {
            this.myUseDefaultBrowser.setVisible(false);
            this.myUseAlternativeBrowser.setVisible(false);
        }
        for (BrowserSettingsProvider settingsProvider : this.mySettingsProviders = (BrowserSettingsProvider[])BrowserSettingsProvider.EP_NAME.getExtensions()) {
            outerPanel.add(settingsProvider.createComponent());
        }
        this.add((Component)outerPanel, "North");
    }

    public boolean isModified() {
        boolean isModified = false;
        GeneralSettings settings = GeneralSettings.getInstance();
        isModified |= !Comparing.strEqual((String)settings.getBrowserPath(), (String)this.myBrowserPathField.getText());
        isModified |= settings.isUseDefaultBrowser() != this.myUseDefaultBrowser.isSelected();
        if (isModified |= settings.isConfirmExtractFiles() != this.myConfirmExtractFiles.isSelected()) {
            return true;
        }
        for (BrowserSettingsProvider provider : this.mySettingsProviders) {
            if (!provider.isModified()) continue;
            return true;
        }
        return false;
    }

    private void updateBrowserField() {
        if (!BrowserUtil.canStartDefaultBrowser()) {
            return;
        }
        this.myBrowserPathField.getTextField().setEnabled(this.myUseAlternativeBrowser.isSelected());
        this.myBrowserPathField.getButton().setEnabled(this.myUseAlternativeBrowser.isSelected());
    }

    public void apply() throws ConfigurationException {
        GeneralSettings settings = GeneralSettings.getInstance();
        settings.setBrowserPath(this.myBrowserPathField.getText());
        settings.setUseDefaultBrowser(this.myUseDefaultBrowser.isSelected());
        settings.setConfirmExtractFiles(this.myConfirmExtractFiles.isSelected());
        for (BrowserSettingsProvider provider : this.mySettingsProviders) {
            provider.apply();
        }
    }

    public void reset() {
        GeneralSettings settings = GeneralSettings.getInstance();
        this.myBrowserPathField.setText(settings.getBrowserPath());
        if (settings.isUseDefaultBrowser()) {
            this.myUseDefaultBrowser.setSelected(true);
        } else {
            this.myUseAlternativeBrowser.setSelected(true);
        }
        this.myConfirmExtractFiles.setSelected(settings.isConfirmExtractFiles());
        this.updateBrowserField();
        for (BrowserSettingsProvider provider : this.mySettingsProviders) {
            provider.reset();
        }
    }
}

