/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.CommonBundle;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.models.RecentChangeDialogModel;
import com.intellij.history.integration.ui.views.DirectoryHistoryDialog;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;

public class RecentChangeDialog
extends DirectoryHistoryDialog {
    private final RecentChange myChange;

    public RecentChangeDialog(IdeaGateway gw, RecentChange c) {
        super(gw, null, false);
        this.myChange = c;
        this.init();
    }

    @Override
    protected DirectoryHistoryDialogModel createModel(LocalVcs vcs) {
        return new RecentChangeDialogModel(this.myGateway, vcs, this.myChange);
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.createDiffPanel();
    }

    @Override
    protected Action[] createActions() {
        AbstractAction revert = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentChangeDialog.this.revert();
            }
        };
        Action help = this.getHelpAction();
        Action cancel = this.getCancelAction();
        UIUtil.setActionNameAndMnemonic((String)LocalHistoryBundle.message("action.revert", new Object[0]), (Action)revert);
        UIUtil.setActionNameAndMnemonic((String)CommonBundle.getCloseButtonText(), (Action)cancel);
        return new Action[]{revert, cancel, help};
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.recentChanges";
    }
}

