/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.diff.Block;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.FormatUtil;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.Progress;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SelectionReverter
extends Reverter {
    private final SelectionCalculator myCalculator;
    private final Revision myLeftRevision;
    private final Entry myRightEntry;
    private final int myFromLine;
    private final int myToLine;

    public SelectionReverter(LocalVcs vcs, IdeaGateway gw, SelectionCalculator c, Revision leftRevision, Entry rightEntry, int fromLine, int toLine) {
        super(vcs, gw);
        this.myCalculator = c;
        this.myLeftRevision = leftRevision;
        this.myRightEntry = rightEntry;
        this.myFromLine = fromLine;
        this.myToLine = toLine;
    }

    @Override
    protected String formatCommandName() {
        String date = FormatUtil.formatTimestamp(this.myLeftRevision.getTimestamp());
        return LocalHistoryBundle.message("system.label.revert.of.selection.to.date", date);
    }

    @Override
    protected List<VirtualFile> getFilesToClearROStatus() throws IOException {
        VirtualFile file = this.myGateway.findVirtualFile(this.myRightEntry.getPath());
        return Collections.singletonList(file);
    }

    @Override
    protected void doRevert() throws IOException {
        Block b = this.myCalculator.getSelectionFor(this.myLeftRevision, new Progress(){

            @Override
            public void processed(int percentage) {
            }
        });
        Document d = this.myGateway.getDocument(this.myRightEntry.getPath());
        int from = d.getLineStartOffset(this.myFromLine);
        int to = d.getLineEndOffset(this.myToLine);
        d.replaceString(from, to, (CharSequence)b.getBlockContent());
    }
}

