/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.CommonBundle;
import com.intellij.history.Clock;
import com.intellij.history.core.ContentFactory;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.Paths;
import com.intellij.history.integration.FileFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;

public class IdeaGateway {
    protected Project myProject;
    protected FileFilter myFileFilter;

    public IdeaGateway(Project p) {
        this.myProject = p;
        this.myFileFilter = this.createFileFilter();
    }

    protected FileFilter createFileFilter() {
        ProjectFileIndex fi = this.getRootManager().getFileIndex();
        FileTypeManager tm = FileTypeManager.getInstance();
        return new FileFilter((FileIndex)fi, tm);
    }

    public Project getProject() {
        return this.myProject;
    }

    public FileFilter getFileFilter() {
        return this.myFileFilter;
    }

    public String getBaseDir() {
        return this.myProject.getBaseDir().getPath();
    }

    public List<VirtualFile> getContentRoots() {
        return Arrays.asList(this.getRootManager().getContentRoots());
    }

    private ProjectRootManager getRootManager() {
        return ProjectRootManager.getInstance((Project)this.myProject);
    }

    public boolean askForProceeding(String s) {
        return Messages.showYesNoDialog((Project)this.myProject, (String)s, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0;
    }

    public void showError(String s) {
        Messages.showErrorDialog((Project)this.myProject, (String)s, (String)CommonBundle.getErrorTitle());
    }

    public void showMessage(String s, String title) {
        Messages.showInfoMessage((Project)this.myProject, (String)s, (String)title);
    }

    public void performCommandInsideWriteAction(final String name, final Runnable r) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                IdeaGateway.this.performCommand(name, r);
            }
        });
    }

    private void performCommand(String name, Runnable r) {
        CommandProcessor.getInstance().executeCommand(this.myProject, r, name, null);
    }

    public boolean ensureFilesAreWritable(List<VirtualFile> ff) {
        ReadonlyStatusHandler h = ReadonlyStatusHandler.getInstance((Project)this.myProject);
        return !h.ensureFilesWritable(ff.toArray(new VirtualFile[0])).hasReadonlyFiles();
    }

    public VirtualFile findVirtualFile(String path) {
        return this.getFileSystem().findFileByPath(path);
    }

    public VirtualFile findOrCreateFileSafely(String path, boolean isDirectory) throws IOException {
        return this.findOrCreateFileSafely(this, path, isDirectory);
    }

    public VirtualFile findOrCreateFileSafely(Object requestor, String path, boolean isDirectory) throws IOException {
        VirtualFile f = this.findVirtualFile(path);
        if (f != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            VirtualFile parent = this.findOrCreateFileSafely(Paths.getParentOf(path), true);
            String name = Paths.getNameOf(path);
            f = isDirectory ? parent.createChildDirectory(requestor, name) : parent.createChildData(requestor, name);
        }
        return f;
    }

    public List<VirtualFile> getAllFilesFrom(String path) {
        return this.collectFiles(this.findVirtualFile(path), new ArrayList<VirtualFile>());
    }

    private List<VirtualFile> collectFiles(VirtualFile f, List<VirtualFile> result) {
        if (f.isDirectory()) {
            for (VirtualFile child : f.getChildren()) {
                this.collectFiles(child, result);
            }
        } else {
            result.add(f);
        }
        return result;
    }

    public void registerUnsavedDocuments(LocalVcs vcs) {
        vcs.beginChangeSet();
        for (Document d : this.getUnsavedDocuments()) {
            VirtualFile f = this.getFile(d);
            if (this.shouldNotRegister(f)) continue;
            this.registerDocumentContents(vcs, f, d);
        }
        vcs.endChangeSet(null);
    }

    public void registerUnsavedDocuments(LocalVcs vcs, VirtualFile f) {
        if (this.shouldNotRegister(f)) {
            return;
        }
        if (f.isDirectory()) {
            for (VirtualFile each : f.getChildren()) {
                this.registerUnsavedDocuments(vcs, each);
            }
        } else {
            this.registerDocumentContents(vcs, f, this.getDocument(f));
        }
    }

    private void registerDocumentContents(LocalVcs vcs, VirtualFile f, Document d) {
        vcs.changeFileContent(f.getPath(), this.contentFactoryFor(d), Clock.getCurrentTimestamp());
    }

    private boolean shouldNotRegister(VirtualFile f) {
        if (f == null) {
            return true;
        }
        if (!f.isValid()) {
            return true;
        }
        return !this.getFileFilter().isAllowedAndUnderContentRoot(f);
    }

    private ContentFactory contentFactoryFor(final Document d) {
        return new ContentFactory(){

            @Override
            public byte[] getBytes() {
                return IdeaGateway.this.bytesFromDocument(d);
            }

            @Override
            public long getLength() {
                return this.getBytes().length;
            }
        };
    }

    protected byte[] bytesFromDocument(Document d) {
        try {
            return d.getText().getBytes(this.getFile(d).getCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return d.getText().getBytes();
        }
    }

    public String stringFromBytes(byte[] bytes, String path) {
        try {
            VirtualFile file = this.findVirtualFile(path);
            if (file == null) {
                return CharsetToolkit.bytesToString((byte[])bytes);
            }
            return new String(bytes, file.getCharset().name());
        }
        catch (UnsupportedEncodingException e1) {
            return new String(bytes);
        }
    }

    public void saveAllUnsavedDocuments() {
        this.getDocManager().saveAllDocuments();
    }

    protected Document[] getUnsavedDocuments() {
        return this.getDocManager().getUnsavedDocuments();
    }

    protected VirtualFile getFile(Document d) {
        return this.getDocManager().getFile(d);
    }

    protected Document getDocument(VirtualFile f) {
        return this.getDocManager().getDocument(f);
    }

    public Document getDocument(String path) {
        return this.getDocument(this.findVirtualFile(path));
    }

    public FileType getFileType(String fileName) {
        return FileTypeManager.getInstance().getFileTypeByFileName(fileName);
    }

    private LocalFileSystem getFileSystem() {
        return LocalFileSystem.getInstance();
    }

    private FileDocumentManager getDocManager() {
        return FileDocumentManager.getInstance();
    }
}

