/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.ChangeSetsProcessor;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeList;
import com.intellij.history.core.revisions.CurrentRevision;
import com.intellij.history.core.revisions.LabeledRevision;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.revisions.RevisionAfterChange;
import com.intellij.history.core.revisions.RevisionBeforeChange;
import com.intellij.history.core.tree.Entry;
import java.util.ArrayList;
import java.util.List;

public class RevisionsCollector
extends ChangeSetsProcessor {
    private final Entry myRoot;
    private final ChangeList myChangeList;
    private final List<Revision> myResult = new ArrayList<Revision>();

    public RevisionsCollector(LocalVcs vcs, String path, Entry rootEntry, ChangeList cl) {
        super(vcs, path);
        this.myRoot = rootEntry;
        this.myChangeList = cl;
    }

    public List<Revision> getResult() {
        this.process();
        return this.myResult;
    }

    @Override
    protected List<Change> collectChanges() {
        return this.myChangeList.getChangesFor(this.myRoot, this.myPath);
    }

    @Override
    protected void nothingToVisit() {
        this.myResult.add(new CurrentRevision(this.myEntry));
    }

    @Override
    protected void visitLabel(Change c) {
        this.myResult.add(new LabeledRevision(this.myEntry, this.myRoot, this.myChangeList, c));
    }

    @Override
    protected void visitRegular(Change c) {
        this.myResult.add(new RevisionAfterChange(this.myEntry, this.myRoot, this.myChangeList, c));
    }

    @Override
    protected void visitFirstAvailableNonCreational(Change c) {
        this.myResult.add(new RevisionBeforeChange(this.myEntry, this.myRoot, this.myChangeList, c));
    }
}

