/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.ArrayList;

public abstract class AbstractBlockWrapper {
    protected WhiteSpace myWhiteSpace;
    protected CompositeBlockWrapper myParent;
    protected int myStart;
    protected int myEnd;
    protected int myFlags;
    static int CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT = 1;
    static int INCOMPLETE = 2;
    protected IndentInfo myIndentFromParent = null;
    private IndentImpl myIndent = null;
    private AlignmentImpl myAlignment;
    private WrapImpl myWrap;

    public AbstractBlockWrapper(Block block, WhiteSpace whiteSpace, CompositeBlockWrapper parent, TextRange textRange) {
        this.myWhiteSpace = whiteSpace;
        this.myParent = parent;
        this.myStart = textRange.getStartOffset();
        this.myEnd = textRange.getEndOffset();
        this.myFlags = CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT | (block.isIncomplete() ? INCOMPLETE : 0);
        this.myAlignment = (AlignmentImpl)block.getAlignment();
        this.myWrap = (WrapImpl)block.getWrap();
    }

    public WhiteSpace getWhiteSpace() {
        return this.myWhiteSpace;
    }

    public ArrayList<WrapImpl> getWraps() {
        ArrayList<WrapImpl> result = new ArrayList<WrapImpl>(3);
        AbstractBlockWrapper current = this;
        while (current != null && current.getStartOffset() == this.getStartOffset()) {
            WrapImpl wrap = current.getOwnWrap();
            if (wrap != null && !result.contains((Object)wrap)) {
                result.add(0, wrap);
            }
            if (wrap != null && wrap.getIgnoreParentWraps()) break;
            current = current.myParent;
        }
        return result;
    }

    public int getStartOffset() {
        return this.myStart;
    }

    public int getEndOffset() {
        return this.myEnd;
    }

    public int getLength() {
        return this.myEnd - this.myStart;
    }

    protected void arrangeStartOffset(int startOffset) {
        if (this.getStartOffset() == startOffset) {
            return;
        }
        boolean isFirst = this.getParent() != null && this.getStartOffset() == this.getParent().getStartOffset();
        this.myStart = startOffset;
        if (isFirst) {
            this.getParent().arrangeStartOffset(startOffset);
        }
    }

    public IndentImpl getIndent() {
        return this.myIndent;
    }

    public CompositeBlockWrapper getParent() {
        return this.myParent;
    }

    public WrapImpl getWrap() {
        ArrayList<WrapImpl> wraps = this.getWraps();
        if (wraps.size() == 0) {
            return null;
        }
        return wraps.get(0);
    }

    public WrapImpl getOwnWrap() {
        return this.myWrap;
    }

    public void reset() {
        WrapImpl wrap;
        this.myFlags |= CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT;
        AlignmentImpl alignment = this.myAlignment;
        if (alignment != null) {
            alignment.reset();
        }
        if ((wrap = this.myWrap) != null) {
            wrap.reset();
        }
    }

    private static IndentData getIndent(CodeStyleSettings.IndentOptions options, AbstractBlockWrapper block, int tokenBlockStartOffset) {
        IndentImpl indent = block.getIndent();
        if (indent.getType() == IndentImpl.Type.CONTINUATION) {
            return new IndentData(options.CONTINUATION_INDENT_SIZE);
        }
        if (indent.getType() == IndentImpl.Type.CONTINUATION_WITHOUT_FIRST) {
            if (block.getStartOffset() != block.getParent().getStartOffset() && block.getStartOffset() == tokenBlockStartOffset) {
                return new IndentData(options.CONTINUATION_INDENT_SIZE);
            }
            return new IndentData(0);
        }
        if (indent.getType() == IndentImpl.Type.LABEL) {
            return new IndentData(options.LABEL_INDENT_SIZE);
        }
        if (indent.getType() == IndentImpl.Type.NONE) {
            return new IndentData(0);
        }
        if (indent.getType() == IndentImpl.Type.SPACES) {
            return new IndentData(0, indent.getSpaces());
        }
        return new IndentData(options.INDENT_SIZE);
    }

    public IndentData getChildOffset(AbstractBlockWrapper child, CodeStyleSettings.IndentOptions options, int tokenBlockStartOffset) {
        IndentData childIndent;
        boolean childOnNewLine = child.getWhiteSpace().containsLineFeeds();
        if (childOnNewLine) {
            childIndent = AbstractBlockWrapper.getIndent(options, child, tokenBlockStartOffset);
        } else {
            IndentImpl.Type type = child.getIndent().getType();
            childIndent = !this.getWhiteSpace().containsLineFeeds() && (type == IndentImpl.Type.NORMAL || type == IndentImpl.Type.CONTINUATION || type == IndentImpl.Type.CONTINUATION_WITHOUT_FIRST) && this.indentAlreadyUsedBefore(child) ? AbstractBlockWrapper.getIndent(options, child, tokenBlockStartOffset) : new IndentData(0);
        }
        if (childOnNewLine && child.getIndent().isAbsolute()) {
            this.myFlags &= ~CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT;
            AbstractBlockWrapper current = this;
            while (current != null && current.getStartOffset() == this.getStartOffset()) {
                current.myFlags &= ~CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT;
                current = current.myParent;
            }
            return childIndent;
        }
        if (child.getStartOffset() == this.getStartOffset()) {
            boolean newValue = (this.myFlags & CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) != 0 && (child.myFlags & CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) != 0 && childIndent.isEmpty();
            this.setCanUseFirstChildIndentAsBlockIndent(newValue);
        }
        if (this.getStartOffset() == tokenBlockStartOffset) {
            if (this.myParent == null) {
                return childIndent;
            }
            return childIndent.add(this.myParent.getChildOffset(this, options, tokenBlockStartOffset));
        }
        if (!this.getWhiteSpace().containsLineFeeds()) {
            return childIndent.add(this.myParent.getChildOffset(this, options, tokenBlockStartOffset));
        }
        if (this.myParent == null) {
            return childIndent.add(this.getWhiteSpace());
        }
        if (this.getIndent().isAbsolute()) {
            if (this.myParent.myParent != null) {
                return childIndent.add(this.myParent.myParent.getChildOffset(this.myParent, options, tokenBlockStartOffset));
            }
            return childIndent.add(this.getWhiteSpace());
        }
        if ((this.myFlags & CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) != 0) {
            return childIndent.add(this.getWhiteSpace());
        }
        return childIndent.add(this.myParent.getChildOffset(this, options, tokenBlockStartOffset));
    }

    protected abstract boolean indentAlreadyUsedBefore(AbstractBlockWrapper var1);

    protected final void setCanUseFirstChildIndentAsBlockIndent(boolean newValue) {
        this.myFlags = newValue ? (this.myFlags |= CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) : (this.myFlags &= ~CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT);
    }

    public void arrangeParentTextRange() {
        if (this.myParent != null) {
            this.myParent.arrangeStartOffset(this.getStartOffset());
        }
    }

    public IndentData calculateChildOffset(CodeStyleSettings.IndentOptions indentOption, ChildAttributes childAttributes, int index) {
        IndentImpl childIndent = (IndentImpl)childAttributes.getChildIndent();
        if (childIndent == null) {
            childIndent = (IndentImpl)Indent.getContinuationWithoutFirstIndent();
        }
        IndentData indent = this.getIndent(indentOption, index, childIndent);
        if (this.myParent == null) {
            return indent.add(this.getWhiteSpace());
        }
        if ((this.myFlags & CAN_USE_FIRST_CHILD_INDENT_AS_BLOCK_INDENT) != 0 && this.getWhiteSpace().containsLineFeeds()) {
            return indent.add(this.getWhiteSpace());
        }
        ArrayList ignored = new ArrayList();
        IndentData offsetFromParent = this.myParent.getChildOffset(this, indentOption, -1);
        IndentData result = indent.add(offsetFromParent);
        if (!ignored.isEmpty()) {
            result = result.add((IndentData)ignored.get(ignored.size() - 1));
        }
        return result;
    }

    private IndentData getIndent(CodeStyleSettings.IndentOptions options, int index, IndentImpl indent) {
        if (indent.getType() == IndentImpl.Type.CONTINUATION) {
            return new IndentData(options.CONTINUATION_INDENT_SIZE);
        }
        if (indent.getType() == IndentImpl.Type.CONTINUATION_WITHOUT_FIRST) {
            if (index != 0) {
                return new IndentData(options.CONTINUATION_INDENT_SIZE);
            }
            return new IndentData(0);
        }
        if (indent.getType() == IndentImpl.Type.LABEL) {
            return new IndentData(options.LABEL_INDENT_SIZE);
        }
        if (indent.getType() == IndentImpl.Type.NONE) {
            return new IndentData(0);
        }
        if (indent.getType() == IndentImpl.Type.SPACES) {
            return new IndentData(0, indent.getSpaces());
        }
        return new IndentData(options.INDENT_SIZE);
    }

    public void setIndentFromParent(IndentInfo indentFromParent) {
        this.myIndentFromParent = indentFromParent;
        if (this.myIndentFromParent != null) {
            CompositeBlockWrapper parent = this.myParent;
            if (this.myParent != null && this.myParent.getStartOffset() == this.myStart) {
                parent.setIndentFromParent(this.myIndentFromParent);
            }
        }
    }

    protected AbstractBlockWrapper findFirstIndentedParent() {
        if (this.myParent == null) {
            return null;
        }
        if (this.myStart != this.myParent.getStartOffset() && this.myParent.getWhiteSpace().containsLineFeeds()) {
            return this.myParent;
        }
        return this.myParent.findFirstIndentedParent();
    }

    public void setIndent(IndentImpl indent) {
        this.myIndent = indent;
    }

    public AlignmentImpl getAlignment() {
        return this.myAlignment;
    }

    public boolean isIncomplete() {
        return (this.myFlags & INCOMPLETE) != 0;
    }

    public void dispose() {
        this.myAlignment = null;
        this.myWrap = null;
        this.myIndent = null;
        this.myIndentFromParent = null;
        this.myParent = null;
        this.myWhiteSpace = null;
    }
}

