/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.EditorSearchComponent;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindModelListener;
import com.intellij.find.FindResult;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindResultImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.usages.UsageViewManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashSet;
import java.awt.Point;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FindManager", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class FindManagerImpl
extends FindManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.impl.FindManagerImpl");
    private final FindUsagesManager myFindUsagesManager;
    private boolean isFindWasPerformed = false;
    private Point myReplaceInFilePromptPos = new Point(-1, -1);
    private Point myReplaceInProjectPromptPos = new Point(-1, -1);
    private final FindModel myFindInProjectModel = new FindModel();
    private final FindModel myFindInFileModel = new FindModel();
    private FindModel myFindNextModel = null;
    private static final FindResultImpl NOT_FOUND_RESULT = new FindResultImpl();
    private final Project myProject;
    private final MessageBus myBus;
    private static final Key<Boolean> HIGHLIGHTER_WAS_NOT_FOUND_KEY = Key.create((String)"com.intellij.find.impl.FindManagerImpl.HighlighterNotFoundKey");
    @NonNls
    private static final String FIND_USAGES_MANAGER_ELEMENT = "FindUsagesManager";
    public static final boolean ourHasSearchInCommentsAndLiterals = ApplicationManagerEx.getApplicationEx().isInternal();
    private FindDialog myFindDialog;
    private static final Key<CommentsLiteralsSearchData> ourCommentsLiteralsSearchDataKey = Key.create((String)"comments.literals.search.data");

    public FindManagerImpl(Project project, FindSettings findSettings, UsageViewManager anotherManager, MessageBus bus) {
        this.myProject = project;
        this.myBus = bus;
        findSettings.initModelBySetings(this.myFindInFileModel);
        findSettings.initModelBySetings(this.myFindInProjectModel);
        this.myFindInFileModel.setCaseSensitive(findSettings.isLocalCaseSensitive());
        this.myFindInFileModel.setWholeWordsOnly(findSettings.isLocalWholeWordsOnly());
        this.myFindUsagesManager = new FindUsagesManager(this.myProject, anotherManager);
        this.myFindInProjectModel.setMultipleFiles(true);
    }

    public Element getState() {
        Element element = new Element("FindManager");
        Element findUsages = new Element(FIND_USAGES_MANAGER_ELEMENT);
        element.addContent(findUsages);
        try {
            this.myFindUsagesManager.writeExternal(findUsages);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return element;
    }

    public void loadState(Element state) {
        Element findUsages = state.getChild(FIND_USAGES_MANAGER_ELEMENT);
        if (findUsages != null) {
            try {
                this.myFindUsagesManager.readExternal(findUsages);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public int showPromptDialog(final FindModel model, String title) {
        ReplacePromptDialog replacePromptDialog = new ReplacePromptDialog(model.isMultipleFiles(), title, this.myProject){

            @Nullable
            public Point getInitialLocation() {
                if (model.isMultipleFiles() && ((FindManagerImpl)FindManagerImpl.this).myReplaceInProjectPromptPos.x >= 0 && ((FindManagerImpl)FindManagerImpl.this).myReplaceInProjectPromptPos.y >= 0) {
                    return FindManagerImpl.this.myReplaceInProjectPromptPos;
                }
                if (!model.isMultipleFiles() && ((FindManagerImpl)FindManagerImpl.this).myReplaceInFilePromptPos.x >= 0 && ((FindManagerImpl)FindManagerImpl.this).myReplaceInFilePromptPos.y >= 0) {
                    return FindManagerImpl.this.myReplaceInFilePromptPos;
                }
                return null;
            }
        };
        replacePromptDialog.show();
        if (model.isMultipleFiles()) {
            this.myReplaceInProjectPromptPos = replacePromptDialog.getLocation();
        } else {
            this.myReplaceInFilePromptPos = replacePromptDialog.getLocation();
        }
        return replacePromptDialog.getExitCode();
    }

    public void showFindDialog(final @NotNull FindModel model, final @NotNull Runnable okHandler) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.showFindDialog must not be null");
        }
        if (okHandler == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.showFindDialog must not be null");
        }
        if (this.myFindDialog == null || Disposer.isDisposed((Disposable)this.myFindDialog.getDisposable())) {
            this.myFindDialog = new FindDialog(this.myProject, model, new Runnable(){

                @Override
                public void run() {
                    String stringToFind = model.getStringToFind();
                    if (stringToFind.length() == 0) {
                        return;
                    }
                    FindSettings.getInstance().addStringToFind(stringToFind);
                    if (!model.isMultipleFiles()) {
                        FindManagerImpl.this.setFindWasPerformed();
                    }
                    if (model.isReplaceState()) {
                        FindSettings.getInstance().addStringToReplace(model.getStringToReplace());
                    }
                    if (model.isMultipleFiles() && !model.isProjectScope()) {
                        FindSettings.getInstance().addDirectory(model.getDirectoryName());
                        if (model.getDirectoryName() != null) {
                            FindManagerImpl.this.myFindInProjectModel.setWithSubdirectories(model.isWithSubdirectories());
                        }
                    }
                    okHandler.run();
                }
            }){

                @Override
                protected void dispose() {
                    super.dispose();
                    FindManagerImpl.this.myFindDialog = null;
                }
            };
            this.myFindDialog.setModal(false);
        }
        this.myFindDialog.show();
    }

    @NotNull
    public FindModel getFindInFileModel() {
        FindModel findModel = this.myFindInFileModel;
        if (findModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindManagerImpl.getFindInFileModel must not return null");
        }
        return findModel;
    }

    @NotNull
    public FindModel getFindInProjectModel() {
        this.myFindInProjectModel.setFromCursor(false);
        this.myFindInProjectModel.setForward(true);
        this.myFindInProjectModel.setGlobal(true);
        FindModel findModel = this.myFindInProjectModel;
        if (findModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindManagerImpl.getFindInProjectModel must not return null");
        }
        return findModel;
    }

    public boolean findWasPerformed() {
        return this.isFindWasPerformed;
    }

    public void setFindWasPerformed() {
        this.isFindWasPerformed = true;
        this.myFindUsagesManager.clearFindingNextUsageInFile();
    }

    public FindModel getFindNextModel() {
        return this.myFindNextModel;
    }

    public FindModel getFindNextModel(@NotNull Editor editor) {
        EditorSearchComponent searchComponent;
        String textInField;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.getFindNextModel must not be null");
        }
        if (this.myFindNextModel == null) {
            return null;
        }
        JComponent header = editor.getHeaderComponent();
        if (header instanceof EditorSearchComponent && !Comparing.equal((String)(textInField = (searchComponent = (EditorSearchComponent)header).getTextInField()), (String)this.myFindInFileModel.getStringToFind()) && textInField.length() > 0) {
            FindModel patched = new FindModel();
            patched.copyFrom(this.myFindNextModel);
            patched.setStringToFind(textInField);
            return patched;
        }
        return this.myFindNextModel;
    }

    public void setFindNextModel(FindModel findNextModel) {
        this.myFindNextModel = findNextModel;
        ((FindModelListener)this.myBus.syncPublisher(FIND_MODEL_TOPIC)).findNextModelChanged();
    }

    @NotNull
    public FindResult findString(@NotNull CharSequence text, int offset, @NotNull FindModel model) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findString must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findString must not be null");
        }
        FindResult findResult = this.findString(text, offset, model, null);
        if (findResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindManagerImpl.findString must not return null");
        }
        return findResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FindResult findString(@NotNull CharSequence text, int offset, @NotNull FindModel model, @Nullable VirtualFile file) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findString must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findString must not be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("offset=" + offset);
            LOG.debug("textlength=" + text.length());
            LOG.debug(model.toString());
        }
        while (true) {
            FindResult findResult;
            FindResult result = FindManagerImpl.doFindString(text, offset, model, file);
            if (!model.isWholeWordsOnly()) {
                findResult = result;
                if (findResult == null) throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindManagerImpl.findString must not return null");
                return findResult;
            }
            if (!result.isStringFound()) {
                findResult = result;
                if (findResult == null) throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindManagerImpl.findString must not return null");
                return findResult;
            }
            if (FindManagerImpl.isWholeWord(text, result.getStartOffset(), result.getEndOffset())) {
                findResult = result;
                if (findResult != null) return findResult;
                throw new IllegalStateException("@NotNull method com/intellij/find/impl/FindManagerImpl.findString must not return null");
            }
            offset = model.isForward() ? result.getStartOffset() + 1 : result.getEndOffset() - 1;
        }
    }

    private static boolean isWholeWord(CharSequence text, int startOffset, int endOffset) {
        boolean isWordStart = startOffset == 0 || !Character.isJavaIdentifierPart(text.charAt(startOffset - 1)) || startOffset > 1 && text.charAt(startOffset - 2) == '\\';
        boolean isWordEnd = endOffset == text.length() || !Character.isJavaIdentifierPart(text.charAt(endOffset)) || endOffset > 0 && !Character.isJavaIdentifierPart(text.charAt(endOffset - 1));
        return isWordStart && isWordEnd;
    }

    private static FindResult doFindString(CharSequence text, int offset, FindModel model, @Nullable VirtualFile file) {
        int res;
        String toFind = model.getStringToFind();
        if (toFind.length() == 0) {
            return NOT_FOUND_RESULT;
        }
        if (model.isInCommentsOnly() || model.isInStringLiteralsOnly()) {
            return FindManagerImpl.findInCommentsAndLiterals(text, offset, model, file);
        }
        if (model.isRegularExpressions()) {
            return FindManagerImpl.findStringByRegularExpression(text, offset, model);
        }
        StringSearcher searcher = FindManagerImpl.createStringSearcher(model);
        int index = model.isForward() ? ((res = searcher.scan(text.subSequence(offset, text.length()))) < 0 ? -1 : res + offset) : searcher.scan(text.subSequence(0, offset));
        if (index < 0) {
            return NOT_FOUND_RESULT;
        }
        return new FindResultImpl(index, index + toFind.length());
    }

    private static StringSearcher createStringSearcher(FindModel model) {
        return new StringSearcher(model.getStringToFind(), model.isCaseSensitive(), model.isForward());
    }

    private static FindResult findInCommentsAndLiterals(CharSequence text, int offset, FindModel model, final VirtualFile file) {
        IElementType tokenType;
        if (file == null) {
            return NOT_FOUND_RESULT;
        }
        FileType ftype = file.getFileType();
        Language lang = null;
        if (ftype instanceof LanguageFileType) {
            lang = ((LanguageFileType)ftype).getLanguage();
        }
        if (lang == null) {
            return NOT_FOUND_RESULT;
        }
        CommentsLiteralsSearchData data = (CommentsLiteralsSearchData)model.getUserData(ourCommentsLiteralsSearchDataKey);
        if (data == null || data.lastFile != file) {
            Lexer lexer = FindManagerImpl.getLexer(file, lang);
            TokenSet tokensOfInterest = TokenSet.EMPTY;
            final Language finalLang = lang;
            Set relevantLanguages = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<Language>>(){

                public Set<Language> compute() {
                    THashSet result = new THashSet();
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        FileViewProvider viewProvider = PsiManager.getInstance((Project)project).findViewProvider(file);
                        if (viewProvider == null) continue;
                        result.addAll((Collection)viewProvider.getLanguages());
                        break;
                    }
                    if (result.isEmpty()) {
                        result.add((Object)finalLang);
                    }
                    return result;
                }
            });
            for (Language relevantLanguage : relevantLanguages) {
                tokensOfInterest = FindManagerImpl.addTokenTypesForLanguage(model, relevantLanguage, tokensOfInterest);
            }
            if (model.isInStringLiteralsOnly()) {
                IElementType convenienceXmlAttrType;
                Lexer xmlLexer = FindManagerImpl.getLexer(null, Language.findLanguageByID((String)"XML"));
                String marker = "xxx";
                xmlLexer.start((CharSequence)"<a href=\"xxx\" />");
                while (!"xxx".equals(xmlLexer.getTokenText())) {
                    xmlLexer.advance();
                    if (xmlLexer.getTokenType() != null) continue;
                }
                if ((convenienceXmlAttrType = xmlLexer.getTokenType()) != null) {
                    tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, TokenSet.create((IElementType[])new IElementType[]{convenienceXmlAttrType})});
                }
            }
            Matcher matcher = model.isRegularExpressions() ? FindManagerImpl.compileRegExp(model, "") : null;
            StringSearcher searcher = matcher != null ? null : FindManagerImpl.createStringSearcher(model);
            data = new CommentsLiteralsSearchData(file, relevantLanguages, lexer, tokensOfInterest, searcher, matcher);
            model.putUserData(ourCommentsLiteralsSearchDataKey, (Object)data);
        }
        data.lexer.start(text, data.startOffset, text.length(), 0);
        Lexer lexer = data.lexer;
        TokenSet tokens = data.tokensOfInterest;
        int lastGoodOffset = 0;
        boolean scanningForward = model.isForward();
        FindResultImpl prevFindResult = NOT_FOUND_RESULT;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (lexer.getState() == 0) {
                lastGoodOffset = lexer.getTokenStart();
            }
            if (tokens.contains(tokenType)) {
                int start = lexer.getTokenStart();
                if (start >= offset || !scanningForward) {
                    FindResultImpl findResult = null;
                    if (data.searcher != null) {
                        int i = data.searcher.scan(text, start, lexer.getTokenEnd());
                        if (i != -1) {
                            findResult = new FindResultImpl(i, i + model.getStringToFind().length());
                        }
                    } else {
                        data.matcher.reset(text.subSequence(start, lexer.getTokenEnd()));
                        if (data.matcher.find()) {
                            int matchStart = data.matcher.start();
                            findResult = new FindResultImpl(start + matchStart, start + data.matcher.end());
                        }
                    }
                    if (findResult != null) {
                        if (scanningForward) {
                            data.startOffset = lastGoodOffset;
                            return findResult;
                        }
                        if (start >= offset) {
                            return prevFindResult;
                        }
                        prevFindResult = findResult;
                    }
                }
            } else {
                Language tokenLang = tokenType.getLanguage();
                if (tokenLang != lang && tokenLang != Language.ANY && !data.relevantLanguages.contains(tokenLang)) {
                    data.tokensOfInterest = tokens = FindManagerImpl.addTokenTypesForLanguage(model, tokenLang, tokens);
                    data.relevantLanguages.add(tokenLang);
                }
            }
            lexer.advance();
        }
        return prevFindResult;
    }

    private static TokenSet addTokenTypesForLanguage(FindModel model, Language lang, TokenSet tokensOfInterest) {
        ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (definition != null) {
            tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, model.isInCommentsOnly() ? definition.getCommentTokens() : TokenSet.EMPTY});
            tokensOfInterest = TokenSet.orSet((TokenSet[])new TokenSet[]{tokensOfInterest, model.isInStringLiteralsOnly() ? definition.getStringLiteralElements() : TokenSet.EMPTY});
        }
        return tokensOfInterest;
    }

    private static Lexer getLexer(VirtualFile file, Language lang) {
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, null, (VirtualFile)file);
        assert (syntaxHighlighter != null) : "Syntax highlighter is null:" + file;
        return syntaxHighlighter.getHighlightingLexer();
    }

    private static FindResult findStringByRegularExpression(CharSequence text, int startOffset, FindModel model) {
        Matcher matcher = FindManagerImpl.compileRegExp(model, text);
        if (model.isForward()) {
            if (matcher.find(startOffset) && matcher.end() <= text.length()) {
                return new FindResultImpl(matcher.start(), matcher.end());
            }
            return NOT_FOUND_RESULT;
        }
        int start = -1;
        int end = -1;
        while (matcher.find() && matcher.end() < startOffset) {
            start = matcher.start();
            end = matcher.end();
        }
        if (start < 0) {
            return NOT_FOUND_RESULT;
        }
        return new FindResultImpl(start, end);
    }

    private static Matcher compileRegExp(FindModel model, CharSequence text) {
        Pattern pattern;
        String toFind = model.getStringToFind();
        try {
            pattern = Pattern.compile(toFind, model.isCaseSensitive() ? 8 : 10);
        }
        catch (PatternSyntaxException e) {
            LOG.error((Throwable)e);
            return null;
        }
        return pattern.matcher(text);
    }

    public String getStringToReplace(@NotNull String foundString, @NotNull FindModel model) {
        if (foundString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.getStringToReplace must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.getStringToReplace must not be null");
        }
        String toReplace = model.getStringToReplace();
        if (model.isRegularExpressions()) {
            return this.getStringToReplaceByRegexp0(foundString, model);
        }
        if (model.isPreserveCase()) {
            return FindManagerImpl.replaceWithCaseRespect(toReplace, foundString);
        }
        return toReplace;
    }

    public String getStringToReplace(@NotNull String foundString, @NotNull FindModel model, int startOffset, @NotNull String documentText) {
        if (foundString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.getStringToReplace must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.getStringToReplace must not be null");
        }
        if (documentText == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.getStringToReplace must not be null");
        }
        String toReplace = model.getStringToReplace();
        if (model.isRegularExpressions()) {
            return this.getStringToReplaceByRegexp(model, documentText, startOffset);
        }
        if (model.isPreserveCase()) {
            return FindManagerImpl.replaceWithCaseRespect(toReplace, foundString);
        }
        return toReplace;
    }

    private String getStringToReplaceByRegexp(final @NotNull FindModel model, @NotNull String text, int startOffset) {
        if (model == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.getStringToReplaceByRegexp must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.getStringToReplaceByRegexp must not be null");
        }
        Matcher matcher = FindManagerImpl.compileRegExp(model, text);
        if (model.isForward()) {
            if (!matcher.find(startOffset)) {
                return null;
            }
            if (matcher.end() > text.length()) {
                return null;
            }
        } else {
            int start = -1;
            while (matcher.find() && matcher.end() < startOffset) {
                start = matcher.start();
            }
            if (start < 0) {
                return null;
            }
        }
        try {
            StringBuffer replaced = new StringBuffer();
            String toReplace = StringUtil.unescapeStringCharacters((String)model.getStringToReplace());
            matcher.appendReplacement(replaced, toReplace);
            return replaced.substring(matcher.start());
        }
        catch (Exception e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)FindManagerImpl.this.myProject, (String)FindBundle.message("find.replace.invalid.replacement.string", model.getStringToReplace()), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                }
            });
            return null;
        }
    }

    private String getStringToReplaceByRegexp0(String foundString, final FindModel model) {
        Pattern pattern;
        String toFind = model.getStringToFind();
        String toReplace = model.getStringToReplace();
        try {
            int flags = 8;
            if (!model.isCaseSensitive()) {
                flags |= 2;
            }
            pattern = Pattern.compile(toFind, flags);
        }
        catch (PatternSyntaxException e) {
            return toReplace;
        }
        Matcher matcher = pattern.matcher(foundString);
        if (matcher.matches()) {
            try {
                return matcher.replaceAll(StringUtil.unescapeStringCharacters((String)toReplace));
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((Project)FindManagerImpl.this.myProject, (String)FindBundle.message("find.replace.invalid.replacement.string", model.getStringToReplace()), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                    }
                });
                return null;
            }
        }
        return toReplace;
    }

    private static String replaceWithCaseRespect(String toReplace, String foundString) {
        if (foundString.length() == 0 || toReplace.length() == 0) {
            return toReplace;
        }
        StringBuilder buffer = new StringBuilder();
        if (Character.isUpperCase(foundString.charAt(0))) {
            buffer.append(Character.toUpperCase(toReplace.charAt(0)));
        } else {
            buffer.append(Character.toLowerCase(toReplace.charAt(0)));
        }
        if (toReplace.length() == 1) {
            return buffer.toString();
        }
        if (foundString.length() == 1) {
            buffer.append(toReplace.substring(1));
            return buffer.toString();
        }
        boolean isTailUpper = true;
        boolean isTailLower = true;
        for (int i = 1; i < foundString.length() && ((isTailUpper &= Character.isUpperCase(foundString.charAt(i))) || (isTailLower &= Character.isLowerCase(foundString.charAt(i)))); ++i) {
        }
        if (isTailUpper) {
            buffer.append(toReplace.substring(1).toUpperCase());
        } else if (isTailLower) {
            buffer.append(toReplace.substring(1).toLowerCase());
        } else {
            buffer.append(toReplace.substring(1));
        }
        return buffer.toString();
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.canFindUsages must not be null");
        }
        return element.isValid() && this.myFindUsagesManager.canFindUsages(element);
    }

    public void findUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findUsages must not be null");
        }
        this.myFindUsagesManager.findUsages(element, null, null);
    }

    public void findUsagesInEditor(@NotNull PsiElement element, @NotNull FileEditor fileEditor) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findUsagesInEditor must not be null");
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findUsagesInEditor must not be null");
        }
        if (fileEditor instanceof TextEditor) {
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            Document document = editor.getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            this.myFindUsagesManager.findUsages(element, psiFile, fileEditor);
        }
    }

    public boolean findNextUsageInEditor(@NotNull FileEditor fileEditor) {
        RangeHighlighter[] highlighters;
        TextEditor textEditor;
        Editor editor;
        FindModel model;
        if (fileEditor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findNextUsageInEditor must not be null");
        }
        if (fileEditor instanceof TextEditor && (model = this.getFindNextModel(editor = (textEditor = (TextEditor)fileEditor).getEditor())) != null && model.searchHighlighters() && (highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)this.myProject)).getHighlighters(editor)).length > 0) {
            return FindManagerImpl.highlightNextHighlighter(highlighters, editor, editor.getCaretModel().getOffset(), true, false);
        }
        return this.myFindUsagesManager.findNextUsageInFile(fileEditor);
    }

    private static boolean highlightNextHighlighter(RangeHighlighter[] highlighters, Editor editor, int offset, boolean isForward, boolean secondPass) {
        RangeHighlighter highlighterToSelect = null;
        Object wasNotFound = editor.getUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY);
        for (RangeHighlighter highlighter : highlighters) {
            int start = highlighter.getStartOffset();
            int end = highlighter.getEndOffset();
            if (!highlighter.isValid() || start >= end) continue;
            if (isForward && (start > offset || start == offset && secondPass) && (highlighterToSelect == null || highlighterToSelect.getStartOffset() > start)) {
                highlighterToSelect = highlighter;
            }
            if (isForward || end >= offset && (end != offset || !secondPass) || highlighterToSelect != null && highlighterToSelect.getEndOffset() >= end) continue;
            highlighterToSelect = highlighter;
        }
        if (highlighterToSelect != null) {
            editor.getSelectionModel().setSelection(highlighterToSelect.getStartOffset(), highlighterToSelect.getEndOffset());
            editor.getCaretModel().moveToOffset(highlighterToSelect.getStartOffset());
            ScrollType scrollType = !secondPass ? (isForward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP) : (isForward ? ScrollType.CENTER_UP : ScrollType.CENTER_DOWN);
            editor.getScrollingModel().scrollToCaret(scrollType);
            editor.putUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY, null);
            return true;
        }
        if (wasNotFound == null) {
            AnAction action;
            String shortcutsText;
            editor.putUserData(HIGHLIGHTER_WAS_NOT_FOUND_KEY, (Object)Boolean.TRUE);
            String message = FindBundle.message("find.highlight.no.more.highlights.found", new Object[0]);
            message = isForward ? ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action = ActionManager.getInstance().getAction("FindNext")))).length() > 0 ? FindBundle.message("find.search.again.from.top.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.top.action.message", message)) : ((shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)(action = ActionManager.getInstance().getAction("FindPrevious")))).length() > 0 ? FindBundle.message("find.search.again.from.bottom.hotkey.message", message, shortcutsText) : FindBundle.message("find.search.again.from.bottom.action.message", message));
            JLabel component = HintUtil.createInformationLabel(message);
            LightweightHint hint = new LightweightHint(component);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
            return true;
        }
        if (!secondPass) {
            offset = isForward ? 0 : editor.getDocument().getTextLength();
            return FindManagerImpl.highlightNextHighlighter(highlighters, editor, offset, isForward, true);
        }
        return false;
    }

    public boolean findPreviousUsageInEditor(@NotNull FileEditor fileEditor) {
        RangeHighlighter[] highlighters;
        TextEditor textEditor;
        Editor editor;
        FindModel model;
        if (fileEditor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/find/impl/FindManagerImpl.findPreviousUsageInEditor must not be null");
        }
        if (fileEditor instanceof TextEditor && (model = this.getFindNextModel(editor = (textEditor = (TextEditor)fileEditor).getEditor())) != null && model.searchHighlighters() && (highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)this.myProject)).getHighlighters(editor)).length > 0) {
            return FindManagerImpl.highlightNextHighlighter(highlighters, editor, editor.getCaretModel().getOffset(), false, false);
        }
        return this.myFindUsagesManager.findPreviousUsageInFile(fileEditor);
    }

    public FindUsagesManager getFindUsagesManager() {
        return this.myFindUsagesManager;
    }

    static class CommentsLiteralsSearchData {
        final VirtualFile lastFile;
        int startOffset = 0;
        final Lexer lexer;
        TokenSet tokensOfInterest;
        final StringSearcher searcher;
        final Matcher matcher;
        final Set<Language> relevantLanguages;

        public CommentsLiteralsSearchData(VirtualFile lastFile, Set<Language> relevantLanguages, Lexer lexer, TokenSet tokensOfInterest, StringSearcher searcher, Matcher matcher) {
            this.lastFile = lastFile;
            this.lexer = lexer;
            this.tokensOfInterest = tokensOfInterest;
            this.searcher = searcher;
            this.matcher = matcher;
            this.relevantLanguages = relevantLanguages;
        }
    }
}

