/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.ui;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NonNls;

public class ProgressTipPanel {
    private JEditorPane myBrowser;
    private JButton myNextHintButton;
    private JButton myPrevHintButton;
    private JPanel myPanel;
    private final String[] myFeatures;
    private final Project myProject;
    private int myCurrentFeature;
    private JLabel myLabel;
    private final Alarm myMarkReadAlarm;
    private static final int MARK_READ_DELAY = 10000;
    private Runnable myLastRequest;
    private JButton myCloseButton;
    private JCheckBox myKeepOpen;
    private JScrollPane myScrollPane;
    @NonNls
    private static final String KEEP_OPTION_NAME = "KEEP_PRODUCTIVITY_HINTS";
    private boolean myIsShownIsOwnDialog;

    public ProgressTipPanel(String[] features, Project project) {
        this.$$$setupUI$$$();
        this.myMarkReadAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myIsShownIsOwnDialog = false;
        this.myFeatures = features;
        this.myProject = project;
        this.myCurrentFeature = 0;
        HTMLEditorKit editorKit = new HTMLEditorKit();
        this.myBrowser.setEditorKit(editorKit);
        this.myBrowser.setContentType("text/html");
        this.myScrollPane.setPreferredSize(new Dimension(600, 200));
        this.myBrowser.setEditable(false);
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.myLabel.setIcon(IconLoader.getIcon((String)"/general/tip.png"));
        Font font = this.myLabel.getFont();
        this.myLabel.setFont(font.deriveFont(0, font.getSize() + 4));
        this.update();
        this.myCloseButton.setVisible(false);
        this.myPanel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                boolean shouldKeep = ProgressTipPanel.this.myKeepOpen.isSelected();
                PropertiesComponent.getInstance().setValue(ProgressTipPanel.KEEP_OPTION_NAME, String.valueOf(shouldKeep));
                if (shouldKeep) {
                    ProgressTipPanel.this.persist();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        if (this.myFeatures.length > 1) {
            this.myNextHintButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProgressTipPanel.this.myCurrentFeature < ProgressTipPanel.this.myFeatures.length - 1) {
                        ProgressTipPanel.this.myCurrentFeature++;
                    }
                    ProgressTipPanel.this.update();
                }
            });
            this.myPrevHintButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProgressTipPanel.this.myCurrentFeature > 0) {
                        ProgressTipPanel.this.myCurrentFeature--;
                    }
                    ProgressTipPanel.this.update();
                }
            });
        } else {
            this.myNextHintButton.setVisible(false);
            this.myPrevHintButton.setVisible(false);
        }
        this.myKeepOpen.setSelected(PropertiesComponent.getInstance().isTrueValue(KEEP_OPTION_NAME));
    }

    private void persist() {
        if (this.myIsShownIsOwnDialog) {
            return;
        }
        this.myIsShownIsOwnDialog = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OwnDialog(ProgressTipPanel.this.myProject).show();
            }
        });
    }

    private void update() {
        this.myPrevHintButton.setEnabled(this.myCurrentFeature > 0);
        this.myNextHintButton.setEnabled(this.myCurrentFeature < this.myFeatures.length - 1);
        final String id = this.myFeatures[this.myCurrentFeature];
        this.myLastRequest = new Runnable(){

            @Override
            public void run() {
                if (ProgressTipPanel.this.myLastRequest == this && !ProgressTipPanel.this.getComponent().isShowing()) {
                    return;
                }
                FeatureUsageTracker.getInstance().triggerFeatureShown(id);
            }
        };
        this.myMarkReadAlarm.addRequest(this.myLastRequest, 10000, ModalityState.current());
        FeatureDescriptor feature = ProductivityFeaturesRegistry.getInstance().getFeatureDescriptor(id);
        String tipFileName = feature.getTipFileName();
        TipUIUtil.openTipInBrowser(tipFileName, this.myBrowser, feature.getProvider());
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JEditorPane jEditorPane;
        JScrollPane jScrollPane;
        JLabel jLabel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPrevHintButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/FeatureStatisticsBundle").getString("feature.statistics.action.prev.tip"));
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myNextHintButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/FeatureStatisticsBundle").getString("feature.statistics.action.next.tip"));
        jPanel2.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCloseButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/FeatureStatisticsBundle").getString("feature.statistics.action.close"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLabel = jLabel = new JLabel();
        jLabel.setIconTextGap(10);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/FeatureStatisticsBundle").getString("feature.statistics.floating.window.title"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myScrollPane = jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        this.myBrowser = jEditorPane = new JEditorPane();
        jScrollPane.setViewportView(jEditorPane);
        this.myKeepOpen = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/FeatureStatisticsBundle").getString("features.statistics.keep.hints.window"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class OwnDialog
    extends DialogWrapper {
        public OwnDialog(Project project) {
            super(project, false);
            this.setTitle(FeatureStatisticsBundle.message((String)"feature.statistics.dialog.title", (Object[])new Object[0]));
            this.setCancelButtonText(CommonBundle.getCloseButtonText());
            this.init();
        }

        protected JComponent createCenterPanel() {
            ProgressTipPanel.this.myKeepOpen.setVisible(false);
            ProgressTipPanel.this.myCloseButton.setVisible(true);
            ProgressTipPanel.this.myCloseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OwnDialog.this.close(0);
                }
            });
            return ProgressTipPanel.this.myPanel;
        }

        protected Action[] createActions() {
            return new Action[0];
        }
    }
}

