/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.ChooseLibrariesDialog;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadingMirrorsMap;
import com.intellij.facet.impl.ui.libraries.RemoteRepositoryMirrorPanel;
import com.intellij.facet.impl.ui.libraries.RequiredLibrariesInfo;
import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.MutualMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryCompositionOptionsPanel {
    private final MutualMap<LibrariesContainer.LibraryLevel, String> myLibraryLevels;
    private JPanel myMainPanel;
    private JButton myAddLibraryButton;
    private JButton myAddJarsButton;
    private JCheckBox myDownloadMissingJarsCheckBox;
    private TextFieldWithBrowseButton myDirectoryField;
    private JComboBox myLibraryLevelComboBox;
    private JTextField myLibraryNameField;
    private JPanel myMissingLibrariesPanel;
    private JPanel myNewLibraryPanel;
    private JPanel myLibraryPropertiesPanel;
    private JPanel myMirrorsPanel;
    private JLabel myMissingLibrariesLabel;
    private JLabel myHiddenLabel;
    private final List<VirtualFile> myAddedJars;
    private final List<Library> myUsedLibraries;
    private final LibrariesContainer myLibrariesContainer;
    private final LibraryCompositionSettings myLibraryCompositionSettings;
    private final List<Library> mySuitableLibraries;
    private final LibraryDownloadingMirrorsMap myMirrorsMap;
    private List<RemoteRepositoryMirrorPanel> myMirrorPanelsList;

    public LibraryCompositionOptionsPanel(@NotNull LibrariesContainer librariesContainer, @NotNull LibraryCompositionSettings libraryCompositionSettings, @NotNull LibraryDownloadingMirrorsMap mirrorsMap) {
        if (librariesContainer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionOptionsPanel.<init> must not be null");
        }
        if (libraryCompositionSettings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionOptionsPanel.<init> must not be null");
        }
        if (mirrorsMap == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibraryCompositionOptionsPanel.<init> must not be null");
        }
        this.$$$setupUI$$$();
        this.myLibraryLevels = new MutualMap(true);
        this.myAddedJars = new ArrayList<VirtualFile>();
        this.myUsedLibraries = new ArrayList<Library>();
        this.myLibrariesContainer = librariesContainer;
        this.myLibraryCompositionSettings = libraryCompositionSettings;
        this.myMirrorsMap = mirrorsMap;
        this.addMirrorsPanels();
        this.myMainPanel.setBorder(BorderFactory.createCompoundBorder(IdeBorderFactory.createTitledBorder((String)libraryCompositionSettings.getTitle()), IdeBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5)));
        this.myDirectoryField.addBrowseFolderListener(ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.title", (Object[])new Object[0]), ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.description", (Object[])new Object[0]), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myAddedJars.addAll(this.myLibraryCompositionSettings.getAddedJars());
        this.myUsedLibraries.addAll(this.myLibraryCompositionSettings.getUsedLibraries());
        this.myAddJarsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryCompositionOptionsPanel.this.showFileChooser();
            }
        });
        this.myAddLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryCompositionOptionsPanel.this.showLibrariesChooser();
            }
        });
        this.myDownloadMissingJarsCheckBox.setSelected(this.myLibraryCompositionSettings.isDownloadLibraries());
        this.myDownloadMissingJarsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryCompositionOptionsPanel.this.updateAll();
            }
        });
        this.mySuitableLibraries = this.calculateSuitableLibraries();
        this.myAddLibraryButton.setEnabled(!this.mySuitableLibraries.isEmpty());
        this.myLibraryLevels.put((Object)LibrariesContainer.LibraryLevel.GLOBAL, (Object)ProjectBundle.message((String)"combobox.item.global.library", (Object[])new Object[0]));
        this.myLibraryLevels.put((Object)LibrariesContainer.LibraryLevel.PROJECT, (Object)ProjectBundle.message((String)"combobox.item.project.library", (Object[])new Object[0]));
        this.myLibraryLevels.put((Object)LibrariesContainer.LibraryLevel.MODULE, (Object)ProjectBundle.message((String)"combobox.item.module.library", (Object[])new Object[0]));
        for (String level : this.myLibraryLevels.getValues()) {
            this.myLibraryLevelComboBox.addItem(level);
        }
        this.myLibraryLevelComboBox.setSelectedItem(this.myLibraryLevels.getValue((Object)this.myLibraryCompositionSettings.getLibraryLevel()));
        this.myLibraryNameField.setText(this.myLibraryCompositionSettings.getLibraryName());
        this.myDirectoryField.setText(FileUtil.toSystemDependentName((String)this.myLibraryCompositionSettings.getDirectoryForDownloadedLibrariesPath()));
        String jars = RequiredLibrariesInfo.getLibrariesPresentableText(this.myLibraryCompositionSettings.getLibraryInfos());
        this.myHiddenLabel.setText(UIUtil.toHtml((String)ProjectBundle.message((String)"label.text.libraries.are.missing", (Object[])new Object[]{jars})));
        this.updateAll();
        this.myMissingLibrariesPanel.getPreferredSize();
        this.myMainPanel.validate();
    }

    public LibraryCompositionSettings getLibraryCompositionSettings() {
        return this.myLibraryCompositionSettings;
    }

    private void addMirrorsPanels() {
        LibraryInfo[] libraryInfos;
        this.myMirrorsPanel.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myMirrorPanelsList = new ArrayList<RemoteRepositoryMirrorPanel>();
        HashSet<String> repositories = new HashSet<String>();
        for (LibraryInfo libraryInfo : libraryInfos = this.myLibraryCompositionSettings.getLibraryInfos()) {
            RemoteRepositoryInfo repositoryInfo;
            LibraryDownloadInfo downloadingInfo = libraryInfo.getDownloadingInfo();
            if (downloadingInfo == null || (repositoryInfo = downloadingInfo.getRemoteRepository()) == null || !repositories.add(repositoryInfo.getId())) continue;
            RemoteRepositoryMirrorPanel mirrorPanel = new RemoteRepositoryMirrorPanel(repositoryInfo, this.myMirrorsMap);
            this.myMirrorPanelsList.add(mirrorPanel);
            this.myMirrorsPanel.add(mirrorPanel.getPanel());
        }
    }

    private List<Library> calculateSuitableLibraries() {
        Library[] libraries;
        LibraryInfo[] libraryInfos = this.myLibraryCompositionSettings.getLibraryInfos();
        RequiredLibrariesInfo requiredLibraries = new RequiredLibrariesInfo(libraryInfos);
        ArrayList<Library> suitableLibraries = new ArrayList<Library>();
        for (Library library : libraries = this.myLibrariesContainer.getAllLibraries()) {
            RequiredLibrariesInfo.RequiredClassesNotFoundInfo info = requiredLibraries.checkLibraries(this.myLibrariesContainer.getLibraryFiles(library, OrderRootType.CLASSES), false);
            if (info != null && info.getLibraryInfos().length >= libraryInfos.length) continue;
            suitableLibraries.add(library);
        }
        return suitableLibraries;
    }

    private void showLibrariesChooser() {
        ChooseLibrariesDialog dialog = new ChooseLibrariesDialog(this.myMainPanel, this.mySuitableLibraries);
        dialog.markElements(this.myUsedLibraries);
        dialog.show();
        if (dialog.isOK()) {
            this.myUsedLibraries.clear();
            this.myUsedLibraries.addAll(dialog.getMarkedLibraries());
            this.updateAll();
        }
    }

    private void showFileChooser() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, false, false, true);
        descriptor.setTitle(IdeBundle.message((String)"file.chooser.select.paths.title", (Object[])new Object[0]));
        descriptor.setDescription(IdeBundle.message((String)"file.chooser.multiselect.description", (Object[])new Object[0]));
        VirtualFile[] files = FileChooser.chooseFiles((Component)this.myAddJarsButton, (FileChooserDescriptor)descriptor, (VirtualFile)this.getBaseDirectory());
        this.myAddedJars.addAll(Arrays.asList(files));
        this.updateAll();
    }

    @Nullable
    private VirtualFile getBaseDirectory() {
        String path = this.myLibraryCompositionSettings.getBaseDirectoryForDownloadedFiles();
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
        if (dir == null) {
            path = path.substring(0, path.lastIndexOf(47));
            dir = LocalFileSystem.getInstance().findFileByPath(path);
        }
        return dir;
    }

    private void updateAll() {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        roots.addAll(this.myAddedJars);
        for (Library library : this.myUsedLibraries) {
            roots.addAll(Arrays.asList(this.myLibrariesContainer.getLibraryFiles(library, OrderRootType.CLASSES)));
        }
        RequiredLibrariesInfo.RequiredClassesNotFoundInfo info = new RequiredLibrariesInfo(this.myLibraryCompositionSettings.getLibraryInfos()).checkLibraries(VfsUtil.toVirtualFileArray(roots), false);
        String missingJarsText = info != null ? ProjectBundle.message((String)"label.text.libraries.are.missing", (Object[])new Object[]{info.getMissingJarsText()}) : ProjectBundle.message((String)"label.text.all.library.files.found", (Object[])new Object[0]);
        this.myMissingLibrariesLabel.setText(UIUtil.toHtml((String)missingJarsText));
        ((CardLayout)this.myMissingLibrariesPanel.getLayout()).show(this.myMissingLibrariesPanel, "shown");
        if (info == null) {
            this.myDownloadMissingJarsCheckBox.setSelected(false);
        }
        this.myNewLibraryPanel.setVisible(info != null || !this.myAddedJars.isEmpty());
        this.myLibraryPropertiesPanel.setVisible(!this.myAddedJars.isEmpty() || this.myDownloadMissingJarsCheckBox.isSelected());
        this.myDownloadMissingJarsCheckBox.setEnabled(info != null);
        this.myDirectoryField.setEnabled(this.myDownloadMissingJarsCheckBox.isSelected());
        UIUtil.setEnabled((Component)this.myMirrorsPanel, (boolean)this.myDownloadMissingJarsCheckBox.isSelected(), (boolean)true);
    }

    public void updateRepositoriesMirrors(LibraryDownloadingMirrorsMap mirrorsMap) {
        for (RemoteRepositoryMirrorPanel mirrorPanel : this.myMirrorPanelsList) {
            mirrorPanel.updateComboBox(mirrorsMap);
        }
    }

    public void saveSelectedRepositoriesMirrors(LibraryDownloadingMirrorsMap mirrorsMap) {
        for (RemoteRepositoryMirrorPanel mirrorPanel : this.myMirrorPanelsList) {
            mirrorsMap.setMirror(mirrorPanel.getRemoteRepository(), mirrorPanel.getSelectedMirror());
        }
    }

    public void apply() {
        this.saveSelectedRepositoriesMirrors(this.myMirrorsMap);
        if (this.myDownloadMissingJarsCheckBox.isSelected()) {
            this.myLibraryCompositionSettings.setDownloadLibraries(true);
            this.myLibraryCompositionSettings.setDirectoryForDownloadedLibrariesPath(FileUtil.toSystemIndependentName((String)this.myDirectoryField.getText()));
        } else {
            this.myLibraryCompositionSettings.setDownloadLibraries(false);
        }
        this.myLibraryCompositionSettings.setUsedLibraries(this.myUsedLibraries);
        this.myLibraryCompositionSettings.setAddedJars(this.myAddedJars);
        this.myLibraryCompositionSettings.setLibraryLevel((LibrariesContainer.LibraryLevel)((Object)this.myLibraryLevels.getKey((Object)((String)this.myLibraryLevelComboBox.getSelectedItem()))));
        this.myLibraryCompositionSettings.setLibraryName(this.myLibraryNameField.getText());
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        JButton jButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMissingLibrariesPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(450, -1), null));
        this.myMissingLibrariesLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel4.add((Component)jLabel2, "shown");
        this.myHiddenLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel4.add((Component)jLabel, "hidden");
        this.myNewLibraryPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDownloadMissingJarsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ProjectBundle").getString("composing.library.download.missing.jars.to"));
        jCheckBox.setSelected(true);
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMirrorsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        jPanel6.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        this.myDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 3));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddJarsButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ProjectBundle").getString("composing.library.add.jars.button"));
        jPanel8.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLibraryPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ProjectBundle").getString("composing.library.name.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myLibraryNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(110, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ProjectBundle").getString("composing.library.level.label"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myLibraryLevelComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(0, 0, 1, 3, 0, 1, 0, 7, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ProjectBundle").getString("composing.liibrary.new.library.label"));
        jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddLibraryButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ProjectBundle").getString("composing.library.use.library.button"));
        jPanel9.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

