/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesValidatorContextImpl
implements LibrariesValidatorContext {
    private final Module myModule;
    private final LibrariesContainer myLibrariesContainer;

    public LibrariesValidatorContextImpl(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/LibrariesValidatorContextImpl.<init> must not be null");
        }
        this.myModule = module;
        this.myLibrariesContainer = LibrariesContainerFactory.createContainer(module);
    }

    @Override
    @Nullable
    public ModuleRootModel getRootModel() {
        return ModuleRootManager.getInstance((Module)this.myModule);
    }

    @Override
    @Nullable
    public ModifiableRootModel getModifiableRootModel() {
        return null;
    }

    private LibraryTable getProjectLibraryTable() {
        return ProjectLibraryTable.getInstance(this.myModule.getProject());
    }

    @Override
    @NotNull
    public ModulesProvider getModulesProvider() {
        DefaultModulesProvider defaultModulesProvider = new DefaultModulesProvider(this.myModule.getProject());
        if (defaultModulesProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/libraries/LibrariesValidatorContextImpl.getModulesProvider must not return null");
        }
        return defaultModulesProvider;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/libraries/LibrariesValidatorContextImpl.getModule must not return null");
        }
        return module;
    }

    @Override
    public LibrariesContainer getLibrariesContainer() {
        return this.myLibrariesContainer;
    }
}

