/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.actions;

import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.impl.ui.FacetEditorFacade;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import java.util.Collection;

public class AddFacetAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ui.actions.AddFacetAction");
    private final FacetEditorFacade myEditor;
    private final FacetType myType;

    public AddFacetAction(FacetEditorFacade editor, FacetType type) {
        super(type.getPresentableName(), null, type.getIcon());
        this.myEditor = editor;
        this.myType = type;
    }

    public void actionPerformed(AnActionEvent e) {
        FacetInfo parent = this.myEditor.getSelectedFacetInfo();
        Collection<FacetInfo> facetInfos = this.myEditor.getFacetsByType(this.myType);
        String facetName = this.myType.getDefaultFacetName();
        int i = 2;
        while (AddFacetAction.facetExists(facetName, facetInfos)) {
            facetName = this.myType.getPresentableName() + i;
            ++i;
        }
        FacetTypeId underlyingFacetType = this.myType.getUnderlyingFacetType();
        if (parent == null && underlyingFacetType == null || parent != null && parent.getFacetType().getId() == underlyingFacetType) {
            this.myEditor.createFacet(parent, this.myType, facetName);
        } else {
            LOG.assertTrue(parent != null);
            FacetInfo grandParent = this.myEditor.getParent(parent);
            LOG.assertTrue(grandParent == null && underlyingFacetType == null || grandParent != null && grandParent.getFacetType().getId() == underlyingFacetType);
            this.myEditor.createFacet(grandParent, this.myType, facetName);
        }
    }

    private static boolean facetExists(String facetName, Collection<FacetInfo> facetInfos) {
        for (FacetInfo facetInfo : facetInfos) {
            if (!facetInfo.getName().equals(facetName)) continue;
            return true;
        }
        return false;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(AddFacetAction.isVisible(this.myEditor, this.myType));
    }

    public static boolean isVisible(FacetEditorFacade editor, FacetType<?, ?> type) {
        ModuleType moduleType = editor.getSelectedModuleType();
        if (moduleType == null || !type.isSuitableModuleType(moduleType)) {
            return false;
        }
        FacetTypeId underlyingTypeId = type.getUnderlyingFacetType();
        FacetInfo selectedFacet = editor.getSelectedFacetInfo();
        if (selectedFacet == null) {
            return underlyingTypeId == null && AddFacetAction.canAddFacet(null, type, editor);
        }
        FacetTypeId selectedFacetType = selectedFacet.getFacetType().getId();
        if (selectedFacetType == underlyingTypeId) {
            return AddFacetAction.canAddFacet(selectedFacet, type, editor);
        }
        FacetInfo parent = editor.getParent(selectedFacet);
        if (!AddFacetAction.canAddFacet(parent, type, editor)) {
            return false;
        }
        return parent == null && underlyingTypeId == null || parent != null && parent.getFacetType().getId() == underlyingTypeId;
    }

    private static boolean canAddFacet(FacetInfo selectedFacet, FacetType<?, ?> type, FacetEditorFacade editor) {
        return !type.isOnlyOneFacetAllowed() || !editor.nodeHasFacetOfType(selectedFacet, type.getId());
    }
}

