/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectConfigurableContext
extends FacetEditorContextBase {
    private final Module myModule;
    private final boolean myNewFacet;
    private final ModuleConfigurationState myModuleConfigurationState;

    public ProjectConfigurableContext(@NotNull Facet facet, boolean isNewFacet, @Nullable FacetEditorContext parentContext, ModuleConfigurationState state, UserDataHolder sharedModuleData, UserDataHolder sharedProjectData) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/ProjectConfigurableContext.<init> must not be null");
        }
        super(facet, parentContext, state.getFacetsProvider(), state.getModulesProvider(), sharedModuleData, sharedProjectData);
        this.myModuleConfigurationState = state;
        this.myNewFacet = isNewFacet;
        this.myModule = facet.getModule();
    }

    @Nullable
    public ModuleBuilder getModuleBuilder() {
        return null;
    }

    public boolean isNewFacet() {
        return this.myNewFacet;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myModule.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/ProjectConfigurableContext.getProject must not return null");
        }
        return project;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/ProjectConfigurableContext.getModule must not return null");
        }
        return module;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel() {
        ModifiableRootModel modifiableRootModel = this.myModuleConfigurationState.getRootModel();
        if (modifiableRootModel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/ProjectConfigurableContext.getModifiableRootModel must not return null");
        }
        return modifiableRootModel;
    }

    @Nullable
    public WizardContext getWizardContext() {
        return null;
    }

    public Library createProjectLibrary(String baseName, VirtualFile[] roots, VirtualFile[] sources) {
        return this.getContainer().createLibrary(baseName, LibrariesContainer.LibraryLevel.PROJECT, roots, sources);
    }

    @Override
    public VirtualFile[] getLibraryFiles(Library library, OrderRootType rootType) {
        return this.getContainer().getLibraryFiles(library, rootType);
    }

    @Override
    @NotNull
    public ArtifactsStructureConfigurableContext getArtifactsStructureContext() {
        ArtifactsStructureConfigurableContext artifactsStructureConfigurableContext = ProjectStructureConfigurable.getInstance(this.getProject()).getArtifactsStructureConfigurable().getArtifactsStructureContext();
        if (artifactsStructureConfigurableContext == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/ProjectConfigurableContext.getArtifactsStructureContext must not return null");
        }
        return artifactsStructureConfigurableContext;
    }
}

