/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting.model;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.impl.autodetecting.model.DetectedFacetInfo;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.FacetInfoBackedByFacet;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetInfoSet<M> {
    private final Map<FacetConfiguration, FacetInfo2<M>> myFacetInfos = new HashMap<FacetConfiguration, FacetInfo2<M>>();
    private final Map<FacetTypeId, MultiValuesMap<M, FacetInfo2<M>>> myInfosByType = new FactoryMap<FacetTypeId, MultiValuesMap<M, FacetInfo2<M>>>(){

        protected MultiValuesMap<M, FacetInfo2<M>> create(FacetTypeId key) {
            return new MultiValuesMap();
        }
    };
    private final Map<Integer, DetectedFacetInfo<M>> myDetectedById = new HashMap<Integer, DetectedFacetInfo<M>>();

    public void addFacetInfo(@NotNull FacetInfo2<M> facetInfo) {
        if (facetInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/FacetInfoSet.addFacetInfo must not be null");
        }
        this.myFacetInfos.put(facetInfo.getConfiguration(), facetInfo);
        this.myInfosByType.get(facetInfo.getFacetType().getId()).put(facetInfo.getModule(), facetInfo);
        if (facetInfo instanceof DetectedFacetInfo) {
            DetectedFacetInfo detected = (DetectedFacetInfo)facetInfo;
            this.myDetectedById.put(detected.getId(), detected);
        }
    }

    public void removeFacetInfo(@NotNull FacetInfo2<M> facetInfo) {
        if (facetInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/FacetInfoSet.removeFacetInfo must not be null");
        }
        this.myFacetInfos.remove(facetInfo.getConfiguration());
        this.myInfosByType.get(facetInfo.getFacetType().getId()).remove(facetInfo.getModule(), facetInfo);
        if (facetInfo instanceof DetectedFacetInfo) {
            DetectedFacetInfo detected = (DetectedFacetInfo)facetInfo;
            this.myDetectedById.remove(detected.getId());
        }
    }

    public void removeDetectedFacets(FacetTypeId<?> type, M module) {
        Collection facets = this.myInfosByType.get(type).get(module);
        if (facets != null) {
            ArrayList infos = new ArrayList(facets);
            for (FacetInfo2 info : infos) {
                if (!(info instanceof DetectedFacetInfo)) continue;
                this.removeFacetInfo(info);
            }
        }
    }

    public void removeDetectedFacets(FacetTypeId<?> type) {
        ArrayList infos = new ArrayList(this.myInfosByType.get(type).values());
        for (FacetInfo2 info : infos) {
            if (!(info instanceof DetectedFacetInfo)) continue;
            this.removeFacetInfo(info);
        }
    }

    @Nullable
    public FacetInfo2 findFacet(@NotNull FacetTypeId<?> typeId, @NotNull M module, @NotNull String name) {
        if (typeId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/FacetInfoSet.findFacet must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/FacetInfoSet.findFacet must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/FacetInfoSet.findFacet must not be null");
        }
        Collection detectedFacets = this.myInfosByType.get(typeId).get(module);
        if (detectedFacets != null) {
            for (FacetInfo2 detected : detectedFacets) {
                if (!detected.getFacetName().equals(name)) continue;
                return detected;
            }
        }
        return null;
    }

    public <C extends FacetConfiguration, F extends Facet<C>> Map<C, FacetInfo2<M>> getConfigurations(FacetTypeId<F> typeId, M module) {
        LinkedHashMap<FacetConfiguration, FacetInfo2> configurations = new LinkedHashMap<FacetConfiguration, FacetInfo2>();
        Collection detectedFacets = this.myInfosByType.get(typeId).get(module);
        if (detectedFacets != null) {
            for (FacetInfo2 detected : detectedFacets) {
                if (!(detected instanceof FacetInfoBackedByFacet)) continue;
                configurations.put(detected.getConfiguration(), detected);
            }
            for (FacetInfo2 detected : detectedFacets) {
                if (detected instanceof FacetInfoBackedByFacet) continue;
                configurations.put(detected.getConfiguration(), detected);
            }
        }
        return configurations;
    }

    public String generateName(M module, FacetType<?, ?> facetType) {
        String baseName = facetType.getDefaultFacetName();
        int i = 2;
        String name = baseName;
        while (this.findFacet(facetType.getId(), module, name) != null) {
            name = baseName + i;
            ++i;
        }
        return name;
    }

    @Nullable
    public FacetInfo2<M> findById(int id) {
        return this.myDetectedById.get(id);
    }

    public void removeDetectedFacetWithSubFacets(Integer id) {
        FacetInfo2 detected = this.myDetectedById.get(id);
        if (detected != null) {
            Set<FacetInfo2<M>> set = this.collectSubFacets(detected);
            for (FacetInfo2<M> info : set) {
                this.removeFacetInfo(info);
            }
        }
    }

    public void removeDetectedFacets(@NotNull M module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/FacetInfoSet.removeDetectedFacets must not be null");
        }
        ArrayList<FacetTypeId> typeIds = new ArrayList<FacetTypeId>(this.myInfosByType.keySet());
        for (FacetTypeId typeId : typeIds) {
            this.removeDetectedFacets(typeId, module);
        }
    }

    private Set<FacetInfo2<M>> collectSubFacets(FacetInfo2<M> facetInfo) {
        HashSet<FacetInfo2<M>> set = new HashSet<FacetInfo2<M>>();
        set.add(facetInfo);
        boolean setChanged = true;
        while (setChanged) {
            setChanged = false;
            for (FacetInfo2<M> info : this.myFacetInfos.values()) {
                FacetInfo2<M> underlying = info.getUnderlyingFacetInfo();
                if (underlying == null || !set.contains(underlying) || set.contains(info)) continue;
                set.add(info);
                setChanged = true;
            }
        }
        return set;
    }

    public Collection<DetectedFacetInfo<M>> getAllDetectedFacets() {
        return Collections.unmodifiableCollection(this.myDetectedById.values());
    }
}

