/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.autodetecting.FacetDetector;
import com.intellij.facet.autodetecting.UnderlyingFacetSelector;
import com.intellij.facet.impl.autodetecting.AutodetectionFilter;
import com.intellij.facet.impl.autodetecting.DetectedFacetManager;
import com.intellij.facet.impl.autodetecting.DisabledAutodetectionByTypeElement;
import com.intellij.facet.impl.autodetecting.DisabledAutodetectionInfo;
import com.intellij.facet.impl.autodetecting.EnableAutodetectionWorker;
import com.intellij.facet.impl.autodetecting.FacetAutodetectingManager;
import com.intellij.facet.impl.autodetecting.FacetByPsiFileDetectorWrapper;
import com.intellij.facet.impl.autodetecting.FacetByVirtualFileDetectorWrapper;
import com.intellij.facet.impl.autodetecting.FacetDetectionIndex;
import com.intellij.facet.impl.autodetecting.FacetDetectionIndexEntry;
import com.intellij.facet.impl.autodetecting.FacetDetectorRegistryEx;
import com.intellij.facet.impl.autodetecting.FacetDetectorWrapper;
import com.intellij.facet.impl.autodetecting.FacetOnTheFlyDetectorRegistry;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.ProjectFacetInfoSet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.SmartList;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FacetAutodetectingManager", storages={@Storage(id="other", file="$PROJECT_FILE$")})
public class FacetAutodetectingManagerImpl
extends FacetAutodetectingManager
implements AutodetectionFilter,
ProjectComponent,
PersistentStateComponent<DisabledAutodetectionInfo> {
    @NonNls
    public static final String COMPONENT_NAME = "FacetAutodetectingManager";
    private final MultiValuesMap<FileType, FacetDetectorWrapper> myDetectors = new MultiValuesMap();
    private final Map<String, FacetDetector<?, ?>> myId2Detector = new HashMap();
    private final Project myProject;
    private final PsiManager myPsiManager;
    private final FacetPointersManager myFacetPointersManager;
    private FacetDetectionIndex myFileIndex;
    private MergingUpdateQueue myMergingUpdateQueue;
    private final ProjectFacetInfoSet myDetectedFacetSet;
    private DetectedFacetManager myDetectedFacetManager;
    private DisabledAutodetectionInfo myDisabledAutodetectionInfo = new DisabledAutodetectionInfo();
    private boolean myDetectionInProgress;
    private final Set<FacetType<?, ?>> myFacetTypesWithDetectors = new THashSet();
    private final EnableAutodetectionWorker myEnableAutodetectionWorker;

    public FacetAutodetectingManagerImpl(Project project, PsiManager psiManager, FacetPointersManager facetPointersManager) {
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myFacetPointersManager = facetPointersManager;
        this.myDetectedFacetSet = new ProjectFacetInfoSet(project, (Disposable)project);
        this.myEnableAutodetectionWorker = new EnableAutodetectionWorker(project, this);
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myDetectedFacetSet.loadDetectedFacets(FacetDetectionIndex.getDetectedFacetsFile(this.myProject));
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                FacetAutodetectingManagerImpl.this.myDetectedFacetManager.initUI();
            }
        });
    }

    public void projectClosed() {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.myDetectedFacetSet.saveDetectedFacets(FacetDetectionIndex.getDetectedFacetsFile(this.myProject));
        if (this.myDetectedFacetManager != null) {
            this.myDetectedFacetManager.disposeUI();
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.getComponentName must not return null");
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!unitTestMode && !this.myProject.isDefault()) {
            this.initialize();
        }
    }

    public void initialize() {
        FacetType[] types;
        this.myDetectedFacetManager = new DetectedFacetManager(this.myProject, this, this.myDetectedFacetSet);
        for (FacetType type : types = FacetTypeRegistry.getInstance().getFacetTypes()) {
            this.registerDetectors(type);
        }
        this.myFileIndex = new FacetDetectionIndex(this.myProject, this, this.myDetectors.keySet());
        this.myFileIndex.initialize();
        MyPsiTreeChangeListener psiTreeChangeListener = new MyPsiTreeChangeListener();
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeListener, (Disposable)this.myProject);
        this.myMergingUpdateQueue = new MergingUpdateQueue("FacetAutodetectionQueue", 500, true, null, (Disposable)this.myProject);
    }

    private <F extends Facet<C>, C extends FacetConfiguration> void registerDetectors(FacetType<F, C> type) {
        FacetOnTheFlyDetectorRegistryImpl<C, F> detectorRegistry = new FacetOnTheFlyDetectorRegistryImpl<C, F>(type);
        type.registerDetectors(new FacetDetectorRegistryEx(null, detectorRegistry));
        if (detectorRegistry.hasDetectors()) {
            this.myFacetTypesWithDetectors.add(type);
            this.myDetectedFacetManager.registerListeners(type);
        }
    }

    @Nullable
    public DisabledAutodetectionByTypeElement getDisabledAutodetectionState(@NotNull FacetType<?, ?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.getDisabledAutodetectionState must not be null");
        }
        return this.myDisabledAutodetectionInfo.findElement(type.getStringId());
    }

    public DisabledAutodetectionInfo getState() {
        return this.myDisabledAutodetectionInfo;
    }

    public void loadState(DisabledAutodetectionInfo state) {
        this.myDisabledAutodetectionInfo = state;
    }

    public void processFile(VirtualFile virtualFile) {
        if (!virtualFile.isValid() || virtualFile.isDirectory() || this.myProject.isDisposed() || !virtualFile.exists() || !this.myFileIndex.getProjectFileIndex().isInContent(virtualFile)) {
            return;
        }
        FileType fileType = virtualFile.getFileType();
        Collection detectors = this.myDetectors.get((Object)fileType);
        if (detectors == null) {
            return;
        }
        List<FacetInfo2<Module>> facets = null;
        for (FacetDetectorWrapper detector : detectors) {
            facets = this.process(virtualFile, detector, facets);
        }
        String url = virtualFile.getUrl();
        FacetDetectionIndexEntry indexEntry = (FacetDetectionIndexEntry)this.myFileIndex.getIndexEntry(url);
        if (indexEntry == null) {
            indexEntry = new FacetDetectionIndexEntry(virtualFile.getTimeStamp());
        }
        Collection<Integer> removed = indexEntry.update(this.myFacetPointersManager, facets);
        this.myFileIndex.putIndexEntry(url, indexEntry);
        if (removed != null) {
            this.removeObsoleteFacets(removed);
        }
    }

    public void removeObsoleteFacets(Collection<Integer> ids) {
        for (Integer id : ids) {
            Set<String> urls = this.myFileIndex.getFiles(id);
            if (urls != null && !urls.isEmpty()) continue;
            this.myDetectedFacetSet.removeDetectedFacetWithSubFacets(id);
        }
    }

    public ProjectFacetInfoSet getDetectedFacetSet() {
        return this.myDetectedFacetSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FacetInfo2<Module>> process(VirtualFile virtualFile, FacetDetectorWrapper<?, ?, ?, ?> detector, List<FacetInfo2<Module>> facets) {
        if (!this.myDetectionInProgress && detector.getVirtualFileFilter().accept(virtualFile)) {
            try {
                this.myDetectionInProgress = true;
                FacetInfo2<Module> facet = detector.detectFacet(virtualFile, this.myPsiManager);
                if (facet != null) {
                    if (facets == null) {
                        facets = new SmartList();
                    }
                    facets.add(facet);
                }
            }
            finally {
                this.myDetectionInProgress = false;
            }
        }
        return facets;
    }

    public void disposeComponent() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !this.myProject.isDefault()) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.myFileIndex != null) {
            this.myFileIndex.dispose();
        }
    }

    @Override
    public boolean hasDetectors(@NotNull FacetType<?, ?> facetType) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.hasDetectors must not be null");
        }
        return this.myFacetTypesWithDetectors.contains(facetType);
    }

    public void redetectFacets() {
        this.myEnableAutodetectionWorker.redetectFacets();
    }

    public EnableAutodetectionWorker getEnableAutodetectionWorker() {
        return this.myEnableAutodetectionWorker;
    }

    @Override
    public boolean isAutodetectionEnabled(Module module, FacetType facetType, String url) {
        return !this.myDisabledAutodetectionInfo.isDisabled(facetType.getStringId(), module.getName(), url);
    }

    private void queueUpdate(PsiFile psiFile) {
        if (!this.myDetectors.keySet().contains(psiFile.getFileType())) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null) {
            this.queueUpdate(virtualFile);
        }
    }

    public void queueUpdate(final VirtualFile file) {
        Update update = new Update("file:" + file.getUrl()){

            public void run() {
                FacetAutodetectingManagerImpl.this.processFile(file);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            update.run();
        } else {
            this.myMergingUpdateQueue.queue(update);
        }
    }

    @Nullable
    public Set<String> getFiles(Facet facet) {
        return this.myFileIndex.getFiles(facet);
    }

    public void removeFacetFromCache(Facet facet) {
        this.myFileIndex.removeFacetFromCache((FacetPointer<Facet>)this.myFacetPointersManager.create(facet));
    }

    public Set<FileType> getFileTypes(Set<FacetType> facetTypes) {
        THashSet fileTypes = new THashSet();
        block0: for (FileType type : this.myDetectors.keySet()) {
            Collection detectorWrappers = this.myDetectors.get((Object)type);
            if (detectorWrappers == null) continue;
            for (FacetDetectorWrapper detectorWrapper : detectorWrappers) {
                if (!facetTypes.contains(detectorWrapper.getFacetType())) continue;
                fileTypes.add((Object)type);
                continue block0;
            }
        }
        return fileTypes;
    }

    @Override
    public void disableAutodetectionInModule(FacetType type, Module module) {
        this.getState().addDisabled(type.getStringId(), module.getName());
    }

    @Override
    public void disableAutodetectionInProject() {
        for (FacetType facetType : FacetTypeRegistry.getInstance().getFacetTypes()) {
            this.disableAutodetectionInProject(facetType);
        }
    }

    @Override
    public void disableAutodetectionInProject(FacetType type) {
        this.getState().addDisabled(type.getStringId());
    }

    @Override
    public void disableAutodetectionInDirs(@NotNull Module module, String ... dirUrls) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.disableAutodetectionInDirs must not be null");
        }
        if (dirUrls == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.disableAutodetectionInDirs must not be null");
        }
        for (FacetType<?, ?> facetType : this.myFacetTypesWithDetectors) {
            for (String dirUrl : dirUrls) {
                this.getState().addDisabled(facetType.getStringId(), module.getName(), dirUrl, true);
            }
        }
    }

    @Override
    public void disableAutodetectionInFiles(@NotNull FacetType type, @NotNull Module module, String ... fileUrls) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.disableAutodetectionInFiles must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.disableAutodetectionInFiles must not be null");
        }
        if (fileUrls == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.disableAutodetectionInFiles must not be null");
        }
        this.getState().addDisabled(type.getStringId(), module.getName(), fileUrls);
    }

    public void setDisabledAutodetectionState(@NotNull FacetType<?, ?> facetType, @Nullable DisabledAutodetectionByTypeElement element) {
        if (facetType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl.setDisabledAutodetectionState must not be null");
        }
        String id = facetType.getStringId();
        DisabledAutodetectionByTypeElement oldElement = this.myDisabledAutodetectionInfo.findElement(id);
        this.myEnableAutodetectionWorker.queueChanges(facetType, oldElement, element);
        this.myDisabledAutodetectionInfo.replaceElement(id, element);
    }

    public DetectedFacetManager getDetectedFacetManager() {
        return this.myDetectedFacetManager;
    }

    @Nullable
    public FacetDetector<?, ?> findDetector(String detectorId) {
        return this.myId2Detector.get(detectorId);
    }

    public FacetDetectionIndex getFileIndex() {
        return this.myFileIndex;
    }

    private class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void childAdded(PsiTreeChangeEvent event) {
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                FacetAutodetectingManagerImpl.this.queueUpdate((PsiFile)child);
            } else {
                this.processChangedElement(event);
            }
        }

        private void processChangedElement(PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile != null) {
                FacetAutodetectingManagerImpl.this.queueUpdate(psiFile);
            }
        }

        public void childRemoved(PsiTreeChangeEvent event) {
            PsiElement child = event.getChild();
            if (child instanceof PsiFile) {
                VirtualFile virtualFile = ((PsiFile)child).getVirtualFile();
                if (virtualFile != null) {
                    FacetAutodetectingManagerImpl.this.myFileIndex.removeIndexEntry(virtualFile);
                }
            } else {
                this.processChangedElement(event);
            }
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            this.processChangedElement(event);
        }

        public void childMoved(PsiTreeChangeEvent event) {
            this.processChangedElement(event);
        }
    }

    private class FacetOnTheFlyDetectorRegistryImpl<C extends FacetConfiguration, F extends Facet<C>>
    implements FacetOnTheFlyDetectorRegistry<C> {
        private final FacetType<F, C> myType;
        private boolean myHasDetectors;

        public FacetOnTheFlyDetectorRegistryImpl(FacetType<F, C> type) {
            this.myType = type;
        }

        @Override
        public <U extends FacetConfiguration> void register(@NotNull FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, @NotNull FacetDetector<VirtualFile, C> facetDetector, UnderlyingFacetSelector<VirtualFile, U> selector) {
            if (fileType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl$FacetOnTheFlyDetectorRegistryImpl.register must not be null");
            }
            if (virtualFileFilter == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl$FacetOnTheFlyDetectorRegistryImpl.register must not be null");
            }
            if (facetDetector == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl$FacetOnTheFlyDetectorRegistryImpl.register must not be null");
            }
            this.myHasDetectors = true;
            FacetAutodetectingManagerImpl.this.myId2Detector.put(facetDetector.getId(), facetDetector);
            FacetAutodetectingManagerImpl.this.myDetectors.put((Object)fileType, new FacetByVirtualFileDetectorWrapper<C, F, U>(FacetAutodetectingManagerImpl.this.myDetectedFacetSet, this.myType, (AutodetectionFilter)FacetAutodetectingManagerImpl.this, virtualFileFilter, facetDetector, selector));
        }

        @Override
        public <U extends FacetConfiguration> void register(@NotNull FileType fileType, @NotNull VirtualFileFilter virtualFileFilter, @NotNull Condition<PsiFile> psiFileFilter, @NotNull FacetDetector<PsiFile, C> facetDetector, UnderlyingFacetSelector<VirtualFile, U> selector) {
            if (fileType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl$FacetOnTheFlyDetectorRegistryImpl.register must not be null");
            }
            if (virtualFileFilter == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl$FacetOnTheFlyDetectorRegistryImpl.register must not be null");
            }
            if (psiFileFilter == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl$FacetOnTheFlyDetectorRegistryImpl.register must not be null");
            }
            if (facetDetector == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/impl/autodetecting/FacetAutodetectingManagerImpl$FacetOnTheFlyDetectorRegistryImpl.register must not be null");
            }
            this.myHasDetectors = true;
            FacetAutodetectingManagerImpl.this.myId2Detector.put(facetDetector.getId(), facetDetector);
            FacetAutodetectingManagerImpl.this.myDetectors.put((Object)fileType, new FacetByPsiFileDetectorWrapper<C, F, U>(FacetAutodetectingManagerImpl.this.myDetectedFacetSet, this.myType, FacetAutodetectingManagerImpl.this, virtualFileFilter, facetDetector, psiFileFilter, selector));
        }

        public boolean hasDetectors() {
            return this.myHasDetectors;
        }
    }
}

