/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting;

import com.intellij.facet.impl.autodetecting.DisabledAutodetectionInModuleElement;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="facet-type")
public class DisabledAutodetectionByTypeElement {
    private String myFacetTypeId;
    private List<DisabledAutodetectionInModuleElement> myModuleElements = new ArrayList<DisabledAutodetectionInModuleElement>();

    public DisabledAutodetectionByTypeElement() {
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId) {
        this.myFacetTypeId = facetTypeId;
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId, String moduleName) {
        this(facetTypeId);
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName));
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId, String moduleName, String url, boolean recursively) {
        this(facetTypeId);
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName, url, recursively));
    }

    @Attribute(value="id")
    public String getFacetTypeId() {
        return this.myFacetTypeId;
    }

    @Tag(value="modules")
    @AbstractCollection(surroundWithTag=false)
    public List<DisabledAutodetectionInModuleElement> getModuleElements() {
        return this.myModuleElements;
    }

    public void setFacetTypeId(String facetTypeId) {
        this.myFacetTypeId = facetTypeId;
    }

    public void setModuleElements(List<DisabledAutodetectionInModuleElement> moduleElements) {
        this.myModuleElements = moduleElements;
    }

    public void addDisabled(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionByTypeElement.addDisabled must not be null");
        }
        if (this.myModuleElements.isEmpty()) {
            return;
        }
        DisabledAutodetectionInModuleElement element = this.findElement(moduleName);
        if (element != null) {
            element.getFiles().clear();
            element.getDirectories().clear();
            return;
        }
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName));
    }

    public void disableInProject() {
        this.myModuleElements.clear();
    }

    public void addDisabled(@NotNull String moduleName, @NotNull String fileUrl, boolean recursively) {
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionByTypeElement.addDisabled must not be null");
        }
        if (fileUrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionByTypeElement.addDisabled must not be null");
        }
        if (this.myModuleElements.isEmpty()) {
            return;
        }
        DisabledAutodetectionInModuleElement element = this.findElement(moduleName);
        if (element != null) {
            if (!element.isDisableInWholeModule()) {
                if (recursively) {
                    element.getDirectories().add(fileUrl);
                } else {
                    element.getFiles().add(fileUrl);
                }
            }
            return;
        }
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName, fileUrl, recursively));
    }

    @Nullable
    public DisabledAutodetectionInModuleElement findElement(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/DisabledAutodetectionByTypeElement.findElement must not be null");
        }
        for (DisabledAutodetectionInModuleElement element : this.myModuleElements) {
            if (!moduleName.equals(element.getModuleName())) continue;
            return element;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisabledAutodetectionByTypeElement that = (DisabledAutodetectionByTypeElement)o;
        return this.myFacetTypeId.equals(that.myFacetTypeId) && ((Object)this.myModuleElements).equals(that.myModuleElements);
    }

    public int hashCode() {
        return this.myFacetTypeId.hashCode() + 31 * ((Object)this.myModuleElements).hashCode();
    }

    public boolean isDisabled(String moduleName, String url) {
        if (this.myModuleElements.isEmpty()) {
            return true;
        }
        DisabledAutodetectionInModuleElement element = this.findElement(moduleName);
        if (element == null) {
            return false;
        }
        if (element.isDisableInWholeModule() || element.getFiles().contains(url)) {
            return true;
        }
        for (String directoryUrl : element.getDirectories()) {
            if (!directoryUrl.endsWith("/")) {
                directoryUrl = directoryUrl + "/";
            }
            if (!url.startsWith(directoryUrl) && (SystemInfo.isFileSystemCaseSensitive || !StringUtil.startsWithIgnoreCase((String)url, (String)directoryUrl))) continue;
            return true;
        }
        return false;
    }

    public boolean removeDisabled(String moduleName) {
        Iterator<DisabledAutodetectionInModuleElement> iterator = this.myModuleElements.iterator();
        while (iterator.hasNext()) {
            DisabledAutodetectionInModuleElement element = iterator.next();
            if (!element.getModuleName().equals(moduleName)) continue;
            iterator.remove();
            break;
        }
        return this.myModuleElements.size() > 0;
    }
}

