/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui.statistics;

import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColumnDuration;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColumnResults;
import com.intellij.execution.testframework.sm.runner.ui.statistics.ColumnTest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.NullableFunction;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsTableModel
extends ListTableModel<SMTestProxy> {
    private static final Logger LOG = Logger.getInstance((String)StatisticsTableModel.class.getName());
    private SMTestProxy myCurrentSuite;
    private final NullableFunction<List<SMTestProxy>, Object> oldReverseModelItemsFun = new NullableFunction<List<SMTestProxy>, Object>(){

        @Nullable
        public Object fun(List<SMTestProxy> proxies) {
            StatisticsTableModel.super.reverseModelItems(proxies);
            return null;
        }
    };

    public StatisticsTableModel() {
        super(new ColumnInfo[]{new ColumnTest(), new ColumnDuration(), new ColumnResults()});
    }

    public void updateModelOnProxySelected(SMTestProxy proxy) {
        SMTestProxy newCurrentSuite = this.getCurrentSuiteFor(proxy);
        if (this.myCurrentSuite != newCurrentSuite) {
            this.myCurrentSuite = newCurrentSuite;
        }
        SMRunnerUtil.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                StatisticsTableModel.this.updateModel();
            }
        });
    }

    @Nullable
    public SMTestProxy getTestAt(int rowIndex) {
        if (rowIndex < 0 || rowIndex > this.getItems().size()) {
            return null;
        }
        return (SMTestProxy)this.getItems().get(rowIndex);
    }

    public int getIndexOf(SMTestProxy test) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            SMTestProxy child = (SMTestProxy)this.getItems().get(i);
            if (child != test) continue;
            return i;
        }
        return -1;
    }

    protected void updateModel() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        this.setItems(this.getItemsForSuite(this.myCurrentSuite));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<SMTestProxy> getItemsForSuite(@Nullable SMTestProxy suite) {
        List<SMTestProxy> list;
        if (suite == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsTableModel.getItemsForSuite must not return null");
            return list;
        }
        ArrayList<SMTestProxy> list2 = new ArrayList<SMTestProxy>();
        list2.add(suite);
        list2.addAll(suite.getChildren());
        list = list2;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/execution/testframework/sm/runner/ui/statistics/StatisticsTableModel.getItemsForSuite must not return null");
    }

    protected void reverseModelItems(List<SMTestProxy> testProxies) {
        StatisticsTableModel.applySortOperation(testProxies, this.oldReverseModelItemsFun);
    }

    protected static void applySortOperation(List<SMTestProxy> proxies, NullableFunction<List<SMTestProxy>, Object> sortOperation) {
        int size = proxies.size();
        if (size > 1) {
            sortOperation.fun(proxies.subList(1, size));
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LOG.error("value: " + aValue + " row: " + rowIndex + " column: " + columnIndex);
    }

    @Nullable
    private SMTestProxy getCurrentSuiteFor(@Nullable SMTestProxy proxy) {
        if (proxy == null) {
            return null;
        }
        SMTestProxy suite = proxy.isSuite() ? proxy : proxy.getParent();
        return suite;
    }

    protected boolean shouldUpdateModelByTest(SMTestProxy test) {
        return this.isSomeSuiteSelected() && test.getParent() == this.myCurrentSuite;
    }

    protected boolean shouldUpdateModelBySuite(SMTestProxy suite) {
        return this.isSomeSuiteSelected() && (suite == this.myCurrentSuite || suite.getParent() == this.myCurrentSuite);
    }

    private boolean isSomeSuiteSelected() {
        return this.myCurrentSuite != null;
    }
}

