/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class SMTRunnerNotificationsHandler
extends SMTRunnerEventsAdapter {
    private final TestConsoleProperties myConsoleProperties;

    public SMTRunnerNotificationsHandler(@NotNull TestConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTRunnerNotificationsHandler.<init> must not be null");
        }
        this.myConsoleProperties = consoleProperties;
    }

    @Override
    public void onTestingStarted(@NotNull SMTestProxy testsRoot) {
        if (testsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTRunnerNotificationsHandler.onTestingStarted must not be null");
        }
    }

    @Override
    public void onTestingFinished(@NotNull SMTestProxy testsRoot) {
        MessageType type;
        String msg;
        if (testsRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTRunnerNotificationsHandler.onTestingFinished must not be null");
        }
        TestStateInfo.Magnitude magnitude = testsRoot.getMagnitudeInfo();
        switch (magnitude) {
            case SKIPPED_INDEX: 
            case IGNORED_INDEX: {
                msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message("sm.test.runner.notifications.tests.skipped.with.errors", new Object[0]) : SMTestsRunnerBundle.message("sm.test.runner.notifications.tests.skipped", new Object[0]);
                type = MessageType.WARNING;
                break;
            }
            case NOT_RUN_INDEX: {
                msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message("sm.test.runner.notifications.tests.not.run.with.errors", new Object[0]) : SMTestsRunnerBundle.message("sm.test.runner.notifications.tests.not.run", new Object[0]);
                type = MessageType.WARNING;
                break;
            }
            case FAILED_INDEX: 
            case ERROR_INDEX: {
                msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message("sm.test.runner.notifications.tests.failed.with.errors", new Object[0]) : SMTestsRunnerBundle.message("sm.test.runner.notifications.tests.failed", new Object[0]);
                type = MessageType.ERROR;
                break;
            }
            case COMPLETE_INDEX: {
                if (testsRoot.getChildren().size() == 0) {
                    msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found.with.errors", new Object[0]) : SMTestsRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", new Object[0]);
                    type = MessageType.ERROR;
                    break;
                }
            }
            case PASSED_INDEX: {
                msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message("sm.test.runner.notifications.tests.passed.with.errors", new Object[0]) : SMTestsRunnerBundle.message("sm.test.runner.notifications.tests.passed", new Object[0]);
                type = MessageType.INFO;
                break;
            }
            default: {
                msg = null;
                type = null;
            }
        }
        if (msg != null) {
            this.notify(msg, type);
        }
    }

    @Override
    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTRunnerNotificationsHandler.onTestFailed must not be null");
        }
    }

    private void notify(final String msg, final MessageType type) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Project project = SMTRunnerNotificationsHandler.this.myConsoleProperties.getProject();
                if (project.isDisposed()) {
                    return;
                }
                if (SMTRunnerNotificationsHandler.this.myConsoleProperties == null) {
                    return;
                }
                String testRunDebugId = SMTRunnerNotificationsHandler.this.myConsoleProperties.isDebug() ? ToolWindowId.DEBUG : ToolWindowId.RUN;
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                if (!Comparing.strEqual((String)toolWindowManager.getActiveToolWindowId(), (String)testRunDebugId)) {
                    toolWindowManager.notifyByBalloon(testRunDebugId, type, msg, null, null);
                }
            }
        });
    }
}

