/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;

public class UnknownBeforeRunTaskProvider
extends BeforeRunTaskProvider<UnknownTask> {
    private final Key<UnknownTask> myId;

    public UnknownBeforeRunTaskProvider(String mirrorProviderName) {
        this.myId = Key.create((String)mirrorProviderName);
    }

    public Key<UnknownTask> getId() {
        return this.myId;
    }

    public String getDescription(RunConfiguration runConfiguration, UnknownTask task) {
        return "Unknown task " + this.myId.toString();
    }

    public boolean configureTask(RunConfiguration runConfiguration, UnknownTask task) {
        return false;
    }

    public boolean executeTask(DataContext context, RunConfiguration configuration, UnknownTask task) {
        return true;
    }

    public boolean hasConfigurationButton() {
        return false;
    }

    public UnknownTask createTask(RunConfiguration runConfiguration) {
        return new UnknownTask();
    }

    public static final class UnknownTask
    extends BeforeRunTask {
        private Element myConfig;

        public void readExternal(Element element) {
            this.myConfig = element;
        }

        public void writeExternal(Element element) {
            if (this.myConfig != null) {
                element.removeContent();
                List attributes = this.myConfig.getAttributes();
                for (Object attribute : attributes) {
                    element.setAttribute((Attribute)((Attribute)attribute).clone());
                }
                for (Object child : this.myConfig.getChildren()) {
                    element.addContent((Element)((Element)child).clone());
                }
            }
        }

        public BeforeRunTask clone() {
            return super.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnknownTask that = (UnknownTask)((Object)o);
            return JDOMUtil.areElementsEqual((Element)this.myConfig, (Element)that.myConfig);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myConfig != null ? this.myConfig.hashCode() : 0);
            return result;
        }
    }
}

