/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerRegistryImpl
extends RunnerRegistry {
    private final List<ProgramRunner> myRunnersOrder = new ArrayList<ProgramRunner>();

    @NotNull
    public String getComponentName() {
        if ("RunnerRegistryImpl" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/impl/RunnerRegistryImpl.getComponentName must not return null");
        }
        return "RunnerRegistryImpl";
    }

    public boolean hasRunner(@NotNull String executorId, @NotNull RunProfile settings) {
        ProgramRunner[] runners;
        if (executorId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/impl/RunnerRegistryImpl.hasRunner must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/impl/RunnerRegistryImpl.hasRunner must not be null");
        }
        for (ProgramRunner runner : runners = this.getRegisteredRunners()) {
            if (!runner.canRun(executorId, settings)) continue;
            return true;
        }
        return false;
    }

    public ProgramRunner getRunner(String executorId, RunProfile settings) {
        ProgramRunner[] runners;
        for (ProgramRunner runner : runners = this.getRegisteredRunners()) {
            if (!runner.canRun(executorId, settings)) continue;
            return runner;
        }
        return null;
    }

    public void initComponent() {
        ProgramRunner[] runners;
        for (ProgramRunner runner : runners = (ProgramRunner[])Extensions.getExtensions((ExtensionPointName)ProgramRunner.PROGRAM_RUNNER_EP)) {
            this.registerRunner(runner);
        }
    }

    public synchronized void disposeComponent() {
        while (this.myRunnersOrder.size() > 0) {
            ProgramRunner runner = this.myRunnersOrder.get(this.myRunnersOrder.size() - 1);
            this.unregisterRunner(runner);
        }
    }

    public synchronized void registerRunner(ProgramRunner runner) {
        if (this.myRunnersOrder.contains(runner)) {
            return;
        }
        this.myRunnersOrder.add(runner);
    }

    public synchronized void unregisterRunner(ProgramRunner runner) {
        this.myRunnersOrder.remove(runner);
    }

    public synchronized ProgramRunner[] getRegisteredRunners() {
        return this.myRunnersOrder.toArray(new ProgramRunner[this.myRunnersOrder.size()]);
    }

    @Nullable
    public ProgramRunner findRunnerById(String id) {
        ProgramRunner[] registeredRunners;
        for (ProgramRunner registeredRunner : registeredRunners = this.getRegisteredRunners()) {
            if (!Comparing.equal((String)id, (String)registeredRunner.getRunnerId())) continue;
            return registeredRunner;
        }
        return null;
    }
}

