/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.application.ApplicationConfigurable2;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements RunJavaConfiguration,
SingleClassConfiguration,
RefactoringListenerProvider {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.application.ApplicationConfiguration");
    public String MAIN_CLASS_NAME;
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    public String WORKING_DIRECTORY;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    public boolean ENABLE_SWING_INSPECTOR;
    public String ENV_VARIABLES;
    private Map<String, String> myEnvs = new LinkedHashMap<String, String>();
    public boolean PASS_PARENT_ENVS = true;

    public ApplicationConfiguration(String name, Project project, ApplicationConfigurationType applicationConfigurationType) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, true), applicationConfigurationType.getConfigurationFactories()[0]);
    }

    @Override
    public void setMainClass(PsiClass psiClass) {
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/application/ApplicationConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/application/ApplicationConfiguration.getState must not be null");
        }
        MyJavaCommandLineState state = new MyJavaCommandLineState(env);
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject()));
        return state;
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ApplicationConfigurable2(this.getProject()));
        RunConfigurationExtension.appendEditors(this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        return group;
    }

    @Nullable
    public String getGeneratedName() {
        if (this.MAIN_CLASS_NAME == null) {
            return null;
        }
        return JavaExecutionUtil.getPresentableClassName((String)this.MAIN_CLASS_NAME, (JavaRunConfigurationModule)((JavaRunConfigurationModule)this.getConfigurationModule()));
    }

    public void setGeneratedName() {
        this.setName(this.getGeneratedName());
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return RefactoringListeners.getClassOrPackageListener(element, new RefactoringListeners.SingleClassConfigurationAccessor(this));
    }

    @Override
    @Nullable
    public PsiClass getMainClass() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.MAIN_CLASS_NAME);
    }

    public boolean isGeneratedName() {
        if (this.MAIN_CLASS_NAME == null || this.MAIN_CLASS_NAME.length() == 0) {
            return JavaExecutionUtil.isNewName((String)this.getName());
        }
        return Comparing.equal((String)this.getName(), (String)this.getGeneratedName());
    }

    public String suggestedName() {
        return ExecutionUtil.shortenName(JavaExecutionUtil.getShortClassName((String)this.MAIN_CLASS_NAME), 6) + ".main()";
    }

    @Override
    public void setMainClassName(String qualifiedName) {
        boolean generatedName = this.isGeneratedName();
        this.MAIN_CLASS_NAME = qualifiedName;
        if (generatedName) {
            this.setGeneratedName();
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.ALTERNATIVE_JRE_PATH_ENABLED && (this.ALTERNATIVE_JRE_PATH == null || this.ALTERNATIVE_JRE_PATH.length() == 0 || !JavaSdkImpl.checkForJre((String)this.ALTERNATIVE_JRE_PATH))) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.mesage", (Object[])new Object[]{this.ALTERNATIVE_JRE_PATH}));
        }
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        PsiClass psiClass = configurationModule.checkModuleAndClassName(this.MAIN_CLASS_NAME, ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        if (!PsiMethodUtil.hasMainMethod((PsiClass)psiClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"main.method.not.found.in.class.error.message", (Object[])new Object[]{this.MAIN_CLASS_NAME}));
        }
        RunConfigurationExtension.checkConfigurationIsValid(this);
    }

    @Override
    public void setProperty(int property, String value) {
        switch (property) {
            case 1: {
                this.PROGRAM_PARAMETERS = value;
                break;
            }
            case 0: {
                this.VM_PARAMETERS = value;
                break;
            }
            case 2: {
                this.WORKING_DIRECTORY = ExternalizablePath.urlValue(value);
                break;
            }
            default: {
                throw new RuntimeException("Unknown property: " + property);
            }
        }
    }

    @Override
    public String getProperty(int property) {
        switch (property) {
            case 1: {
                return this.PROGRAM_PARAMETERS;
            }
            case 0: {
                return this.VM_PARAMETERS;
            }
            case 2: {
                return this.getWorkingDirectory();
            }
        }
        throw new RuntimeException("Unknown property: " + property);
    }

    @Override
    @Nullable
    public String getRunClass() {
        return this.MAIN_CLASS_NAME;
    }

    @Override
    @Nullable
    public String getPackage() {
        return null;
    }

    @Override
    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    @Override
    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    @Override
    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    @Override
    public void setAlternativeJrePath(String ALTERNATIVE_JRE_PATH) {
        this.ALTERNATIVE_JRE_PATH = ALTERNATIVE_JRE_PATH;
    }

    private String getWorkingDirectory() {
        return ExternalizablePath.localPathValue(this.WORKING_DIRECTORY);
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.MAIN_CLASS_NAME);
    }

    protected ModuleBasedConfiguration createInstance() {
        return new ApplicationConfiguration(this.getName(), this.getProject(), ApplicationConfigurationType.getInstance());
    }

    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        RunConfigurationExtension.readSettings(this, element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.readModule(element);
        EnvironmentVariablesComponent.readExternal((Element)element, this.getEnvs());
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        RunConfigurationExtension.writeSettings(this, element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.writeModule(element);
        EnvironmentVariablesComponent.writeExternal((Element)element, this.getEnvs());
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    public Map<String, String> getEnvs() {
        return this.myEnvs;
    }

    public void setEnvs(Map<String, String> envs) {
        this.myEnvs = envs;
    }

    private class MyJavaCommandLineState
    extends JavaCommandLineState {
        public MyJavaCommandLineState(ExecutionEnvironment environment) {
            super(environment);
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            JavaParameters params = new JavaParameters();
            params.setupEnvs(ApplicationConfiguration.this.getEnvs(), ApplicationConfiguration.this.PASS_PARENT_ENVS);
            int classPathType = JavaParametersUtil.getClasspathType(ApplicationConfiguration.this.getConfigurationModule(), ApplicationConfiguration.this.MAIN_CLASS_NAME, false);
            JavaParametersUtil.configureModule(ApplicationConfiguration.this.getConfigurationModule(), params, classPathType | 8, ApplicationConfiguration.this.ALTERNATIVE_JRE_PATH_ENABLED ? ApplicationConfiguration.this.ALTERNATIVE_JRE_PATH : null);
            JavaParametersUtil.configureConfiguration(params, ApplicationConfiguration.this);
            params.setMainClass(ApplicationConfiguration.this.MAIN_CLASS_NAME);
            for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions(RunConfigurationExtension.EP_NAME)) {
                ext.updateJavaParameters(ApplicationConfiguration.this, params, this.getRunnerSettings());
            }
            return params;
        }

        protected OSProcessHandler startProcess() throws ExecutionException {
            OSProcessHandler handler = super.startProcess();
            for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions(RunConfigurationExtension.EP_NAME)) {
                ext.handleStartProcess(ApplicationConfiguration.this, handler);
            }
            return handler;
        }
    }
}

