/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.JavaAwareFilter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class AbstractRerunFailedTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.actions.RerunFailedTestsAction");
    private TestFrameworkRunningModel myModel;
    private Getter<TestFrameworkRunningModel> myModelProvider;
    protected TestConsoleProperties myConsoleProperties;
    protected RunnerSettings myRunnerSettings;
    protected ConfigurationPerRunnerSettings myConfigurationPerRunnerSettings;

    public void init(TestConsoleProperties consoleProperties, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSettings) {
        this.myConfigurationPerRunnerSettings = configurationSettings;
        this.myRunnerSettings = runnerSettings;
        this.myConsoleProperties = consoleProperties;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    public void setModelProvider(Getter<TestFrameworkRunningModel> modelProvider) {
        this.myModelProvider = modelProvider;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.isActive(e));
    }

    private boolean isActive(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        TestFrameworkRunningModel model = this.getModel();
        if (model == null || model.getRoot() == null) {
            return false;
        }
        List<AbstractTestProxy> failed = this.getFailedTests(project);
        return !failed.isEmpty();
    }

    @NotNull
    protected List<AbstractTestProxy> getFailedTests(Project project) {
        List<? extends AbstractTestProxy> myAllTests = this.getModel().getRoot().getAllTests();
        List<AbstractTestProxy> list = Filter.DEFECTIVE_LEAF.and(JavaAwareFilter.METHOD(project)).select(myAllTests);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/actions/AbstractRerunFailedTestsAction.getFailedTests must not return null");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        boolean isDebug = this.myConsoleProperties.isDebug();
        MyRunProfile profile = this.getRunProfile();
        try {
            Executor executor = isDebug ? DefaultDebugExecutor.getDebugExecutorInstance() : DefaultRunExecutor.getRunExecutorInstance();
            ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)profile);
            assert (runner != null);
            runner.execute(executor, new ExecutionEnvironment((RunProfile)profile, this.myRunnerSettings, this.myConfigurationPerRunnerSettings, dataContext));
        }
        catch (ExecutionException e1) {
            LOG.error((Throwable)e1);
        }
        finally {
            profile.clear();
        }
    }

    public MyRunProfile getRunProfile() {
        return null;
    }

    public TestFrameworkRunningModel getModel() {
        if (this.myModel != null) {
            return this.myModel;
        }
        if (this.myModelProvider != null) {
            return (TestFrameworkRunningModel)this.myModelProvider.get();
        }
        return null;
    }

    protected static abstract class MyRunProfile
    extends RunConfigurationBase
    implements ModuleRunProfile {
        private final RunConfigurationBase myConfiguration;

        public MyRunProfile(RunConfigurationBase configuration) {
            super(configuration.getProject(), configuration.getFactory(), ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]));
            this.myConfiguration = configuration;
        }

        public void clear() {
        }

        public void checkConfiguration() throws RuntimeConfigurationException {
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.myConfiguration.readExternal(element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.myConfiguration.writeExternal(element);
        }

        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            return this.myConfiguration.getConfigurationEditor();
        }

        @NotNull
        public ConfigurationType getType() {
            ConfigurationType configurationType = this.myConfiguration.getType();
            if (configurationType == null) {
                throw new IllegalStateException("@NotNull method com/intellij/execution/actions/AbstractRerunFailedTestsAction$MyRunProfile.getType must not return null");
            }
            return configurationType;
        }

        public JDOMExternalizable createRunnerSettings(ConfigurationInfoProvider provider) {
            return this.myConfiguration.createRunnerSettings(provider);
        }

        public SettingsEditor<JDOMExternalizable> getRunnerSettingsEditor(ProgramRunner runner) {
            return this.myConfiguration.getRunnerSettingsEditor(runner);
        }

        public RunConfiguration clone() {
            return this.myConfiguration.clone();
        }

        public int getUniqueID() {
            return this.myConfiguration.getUniqueID();
        }

        public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
            return this.myConfiguration.getOptionsForPredefinedLogFile(predefinedLogFile);
        }

        public ArrayList<PredefinedLogFile> getPredefinedLogFiles() {
            return this.myConfiguration.getPredefinedLogFiles();
        }

        public ArrayList<LogFileOptions> getAllLogFiles() {
            return this.myConfiguration.getAllLogFiles();
        }

        public ArrayList<LogFileOptions> getLogFiles() {
            return this.myConfiguration.getLogFiles();
        }
    }
}

