/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.ValueMarkup;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class ValueDescriptorImpl
extends NodeDescriptorImpl
implements ValueDescriptor {
    protected final Project myProject;
    NodeRenderer myRenderer = null;
    NodeRenderer myAutoRenderer = null;
    private Value myValue;
    private EvaluateException myValueException;
    protected EvaluationContextImpl myStoredEvaluationContext = null;
    private String myValueLabel;
    protected boolean myIsNew = true;
    private boolean myIsDirty = false;
    private boolean myIsLvalue = false;
    private boolean myIsExpandable;
    public static final int MAX_DISPLAY_LABEL_LENGTH = 524288;

    protected ValueDescriptorImpl(Project project, Value value) {
        this.myProject = project;
        this.myValue = value;
    }

    protected ValueDescriptorImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean isArray() {
        return this.myValue instanceof ArrayReference;
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    @Override
    public boolean isLvalue() {
        return this.myIsLvalue;
    }

    @Override
    public boolean isNull() {
        return this.myValue == null;
    }

    @Override
    public boolean isPrimitive() {
        return this.myValue instanceof PrimitiveValue;
    }

    public boolean isValueValid() {
        return this.myValueException == null;
    }

    @Override
    public Value getValue() {
        if (Patches.IBM_JDK_DISABLE_COLLECTION_BUG && this.myStoredEvaluationContext != null && !this.myStoredEvaluationContext.getSuspendContext().isResumed() && this.myValue instanceof ObjectReference && VirtualMachineProxyImpl.isCollected((ObjectReference)this.myValue)) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            this.myStoredEvaluationContext.getDebugProcess().getManagerThread().invoke(new SuspendContextCommandImpl(this.myStoredEvaluationContext.getSuspendContext()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void contextAction() throws Exception {
                    try {
                        ValueDescriptorImpl.this.setContext(ValueDescriptorImpl.this.myStoredEvaluationContext);
                    }
                    finally {
                        semaphore.up();
                    }
                }
            });
            semaphore.waitFor();
        }
        return this.myValue;
    }

    @Override
    public boolean isExpandable() {
        return this.myIsExpandable;
    }

    public abstract Value calcValue(EvaluationContextImpl var1) throws EvaluateException;

    @Override
    public final void setContext(EvaluationContextImpl evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
            this.myStoredEvaluationContext = evaluationContext;
        }
        try {
            Value value;
            block8: {
                value = this.calcValue(evaluationContext);
                if (!this.myIsNew) {
                    try {
                        if (this.myValue instanceof DoubleValue && Double.isNaN(((DoubleValue)this.myValue).doubleValue())) {
                            this.myIsDirty = !(value instanceof DoubleValue);
                            break block8;
                        }
                        if (this.myValue instanceof FloatValue && Float.isNaN(((FloatValue)this.myValue).floatValue())) {
                            this.myIsDirty = !(value instanceof FloatValue);
                            break block8;
                        }
                        this.myIsDirty = value == null ? this.myValue != null : !value.equals(this.myValue);
                    }
                    catch (ObjectCollectedException e) {
                        this.myIsDirty = true;
                    }
                }
            }
            this.myValue = value;
            this.myValueException = null;
        }
        catch (EvaluateException e) {
            this.myValueException = e;
            this.myValue = ValueDescriptorImpl.getTargetExceptionWithStackTraceFilled(evaluationContext, e);
            this.myIsExpandable = false;
        }
        this.myIsNew = false;
    }

    @Nullable
    private static ObjectReference getTargetExceptionWithStackTraceFilled(EvaluationContextImpl evaluationContext, EvaluateException ex) {
        ObjectReference exceptionObj = ex.getExceptionFromTargetVM();
        if (exceptionObj != null) {
            try {
                ReferenceType refType = exceptionObj.referenceType();
                List<Method> methods = refType.methodsByName("getStackTrace", "()[Ljava/lang/StackTraceElement;");
                if (methods.size() > 0) {
                    ArrayReference traceArray;
                    Type componentType;
                    Value trace;
                    DebugProcessImpl process = evaluationContext.getDebugProcess();
                    process.invokeMethod((EvaluationContext)evaluationContext, exceptionObj, methods.get(0), Collections.emptyList());
                    Field traceField = refType.fieldByName("stackTrace");
                    Value value = trace = traceField != null ? exceptionObj.getValue(traceField) : null;
                    if (trace instanceof ArrayReference && (componentType = ((ArrayType)(traceArray = (ArrayReference)trace).referenceType()).componentType()) instanceof ClassType) {
                        process.printToConsole(DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)exceptionObj));
                        process.printToConsole("\n");
                        for (Value stackElement : traceArray.getValues()) {
                            process.printToConsole("\tat ");
                            process.printToConsole(DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)stackElement));
                            process.printToConsole("\n");
                        }
                    }
                }
            }
            catch (EvaluateException ignored) {
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                // empty catch block
            }
        }
        return exceptionObj;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        this.myIsNew = false;
        this.myValue = ((ValueDescriptorImpl)oldDescriptor).getValue();
    }

    protected void setLvalue(boolean value) {
        this.myIsLvalue = value;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        this.myIsExpandable = (this.myValueException == null || this.myValueException.getExceptionFromTargetVM() != null) && this.getRenderer(context.getDebugProcess()).isExpandable(this.getValue(), context, this);
        return this.setValueLabel(this.calcValueLabel(context, labelListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCustomLabel(String label) {
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            if (this.getValue() instanceof ObjectReference) {
                String idLabel;
                ObjectReference value = (ObjectReference)this.getValue();
                String string = idLabel = value != null ? ValueDescriptorImpl.getIdLabel(value) : "";
                if (!label.startsWith(idLabel)) {
                    buf.append(idLabel);
                }
            }
            if (label == null) {
                buf.append("null");
            } else {
                boolean isQuoted;
                boolean bl = isQuoted = label.length() > 1 && StringUtil.startsWithChar((CharSequence)label, (char)'\"') && StringUtil.endsWithChar((CharSequence)label, (char)'\"');
                if (isQuoted) {
                    label = label.substring(1, label.length() - 1);
                    buf.append('\"');
                }
                if (label.length() > 524288) {
                    label = DebuggerUtils.translateStringValue((String)label.substring(0, 524288));
                    buf.append(label);
                    if (!label.endsWith("...")) {
                        buf.append("...");
                    }
                } else {
                    buf.append(DebuggerUtils.translateStringValue((String)label));
                }
                if (isQuoted) {
                    buf.append('\"');
                }
            }
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    @Override
    public String setValueLabel(String label) {
        String customLabel;
        this.myValueLabel = customLabel = this.getCustomLabel(label);
        return this.setLabel(this.calcValueName() + " = " + customLabel);
    }

    @Override
    public String setValueLabelFailed(EvaluateException e) {
        String label = this.setFailed(e);
        this.setValueLabel(label);
        return label;
    }

    public abstract String calcValueName();

    private String calcValueLabel(EvaluationContextImpl evaluationContext, DescriptorLabelListener labelListener) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myValueException != null) {
                throw this.myValueException;
            }
            return this.getRenderer(evaluationContext.getDebugProcess()).calcLabel(this, evaluationContext, labelListener);
        }
        catch (EvaluateException e) {
            return this.setValueLabelFailed(e);
        }
    }

    @Override
    public void displayAs(NodeDescriptor descriptor) {
        if (descriptor instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
            this.myRenderer = valueDescriptor.myRenderer;
        }
        super.displayAs(descriptor);
    }

    public Renderer getLastRenderer() {
        return this.myRenderer != null ? this.myRenderer : this.myAutoRenderer;
    }

    @Nullable
    public Type getType() {
        Value value = this.getValue();
        return value != null ? value.type() : null;
    }

    public NodeRenderer getRenderer(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Type type = this.getType();
        if (type != null && this.myRenderer != null && this.myRenderer.isApplicable(type)) {
            return this.myRenderer;
        }
        this.myAutoRenderer = debugProcess.getAutoRenderer(this);
        return this.myAutoRenderer;
    }

    public void setRenderer(NodeRenderer renderer) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myRenderer = renderer;
        this.myAutoRenderer = null;
    }

    public PsiExpression getTreeEvaluation(DebuggerTreeNodeImpl debuggerTreeNode, DebuggerContextImpl context) throws EvaluateException {
        if (debuggerTreeNode.getParent() != null && debuggerTreeNode.getParent().getDescriptor() instanceof ValueDescriptor) {
            NodeDescriptorImpl descriptor = debuggerTreeNode.getParent().getDescriptor();
            ValueDescriptorImpl vDescriptor = (ValueDescriptorImpl)descriptor;
            PsiExpression parentEvaluation = vDescriptor.getTreeEvaluation(debuggerTreeNode.getParent(), context);
            if (parentEvaluation == null) {
                return null;
            }
            return DebuggerTreeNodeExpression.substituteThis(vDescriptor.getRenderer(context.getDebugProcess()).getChildValueExpression(debuggerTreeNode, context), parentEvaluation, vDescriptor.getValue());
        }
        return this.getDescriptorEvaluation(context);
    }

    @Override
    public abstract PsiExpression getDescriptorEvaluation(DebuggerContext var1) throws EvaluateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIdLabel(ObjectReference objRef) {
        StringBuilder buf = StringBuilderSpinAllocator.alloc();
        try {
            int idx;
            boolean showConcreteType;
            ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            boolean bl = showConcreteType = !classRenderer.SHOW_DECLARED_TYPE || !(objRef instanceof StringReference) && !(objRef instanceof ClassObjectReference) && !ValueDescriptorImpl.isEnumConstant(objRef);
            if (showConcreteType || classRenderer.SHOW_OBJECT_ID) {
                buf.append('{');
                if (showConcreteType) {
                    buf.append(objRef.type().name());
                }
                if (classRenderer.SHOW_OBJECT_ID) {
                    buf.append('@');
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        buf.append("uniqueID");
                    } else {
                        buf.append(objRef.uniqueID());
                    }
                }
                buf.append('}');
            }
            if (objRef instanceof ArrayReference && (idx = buf.indexOf("[")) >= 0) {
                buf.insert(idx + 1, Integer.toString(((ArrayReference)objRef).length()));
            }
            String string = buf.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
        }
    }

    private static boolean isEnumConstant(ObjectReference objRef) {
        Type type = objRef.type();
        return type instanceof ClassType && ((ClassType)type).isEnum();
    }

    public boolean canSetValue() {
        return !this.myIsSynthetic && this.isLvalue();
    }

    public String getValueLabel() {
        return this.myValueLabel;
    }

    @Override
    public void clear() {
        super.clear();
        this.setValueLabel("");
        this.myIsExpandable = false;
    }

    @Override
    @Nullable
    public ValueMarkup getMarkup(DebugProcess debugProcess) {
        Value value = this.getValue();
        if (value instanceof ObjectReference) {
            long id = ((ObjectReference)value).uniqueID();
            Map<Long, ValueMarkup> map = ValueDescriptorImpl.getMarkupMap(debugProcess);
            if (map != null) {
                return map.get(id);
            }
        }
        return null;
    }

    @Override
    public void setMarkup(DebugProcess debugProcess, @Nullable ValueMarkup markup) {
        Map<Long, ValueMarkup> map;
        Value value = this.getValue();
        if (value instanceof ObjectReference && (map = ValueDescriptorImpl.getMarkupMap(debugProcess)) != null) {
            long id = ((ObjectReference)value).uniqueID();
            if (markup != null) {
                map.put(id, markup);
            } else {
                map.remove(id);
            }
        }
    }
}

