/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.InspectPanel;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class InspectDialog
extends DialogWrapper
implements DebuggerContextListener {
    private InspectPanel myInspectView;
    private final DebuggerContextImpl myDebuggerContext;

    public InspectDialog(Project project, DebuggerStateManager stateManager, String title, NodeDescriptorImpl inspectDescriptor) {
        super(project, true);
        this.setTitle(title);
        this.setModal(false);
        this.myDebuggerContext = stateManager.getContext();
        this.myInspectView = new InspectPanel(project, this.myDebuggerContext.getDebuggerSession().getContextManager(), inspectDescriptor);
        this.myInspectView.setBorder(BorderFactory.createEtchedBorder());
        this.init();
        this.myDebuggerContext.getDebuggerSession().getContextManager().addListener(this);
        this.getInspectView().rebuildIfVisible(8);
    }

    protected JComponent createCenterPanel() {
        return this.myInspectView;
    }

    protected JComponent createSouthPanel() {
        return null;
    }

    public void dispose() {
        this.myDebuggerContext.getDebuggerSession().getContextManager().removeListener(this);
        if (this.myInspectView != null) {
            this.myInspectView.dispose();
            this.myInspectView = null;
        }
        super.dispose();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.impl.InspectDialog";
    }

    public InspectPanel getInspectView() {
        return this.myInspectView;
    }

    @Override
    public void changeEvent(DebuggerContextImpl newContext, int event) {
        if (event == 1) {
            this.close(1);
        }
    }
}

