/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.AnyExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointPanel;
import com.intellij.debugger.ui.breakpoints.actions.BreakpointPanelAction;
import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;

public class RemoveAction
extends BreakpointPanelAction {
    private final Project myProject;

    public RemoveAction(Project project) {
        super(DebuggerBundle.message((String)"button.remove", (Object[])new Object[0]));
        this.myProject = project;
    }

    @Override
    public void setButton(AbstractButton button) {
        super.setButton(button);
    }

    @Override
    public void setPanel(BreakpointPanel panel) {
        super.setPanel(panel);
        this.getPanel().getTable().registerKeyboardAction(this, KeyStroke.getKeyStroke(127, 0), 1);
        this.getPanel().getTree().registerKeyboardAction(this, KeyStroke.getKeyStroke(127, 0), 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Breakpoint[] breakpoints = this.getPanel().getSelectedBreakpoints();
        if (breakpoints != null) {
            for (Breakpoint breakpoint1 : breakpoints) {
                if (!(breakpoint1 instanceof AnyExceptionBreakpoint)) continue;
                return;
            }
            this.getPanel().removeSelectedBreakpoints();
            BreakpointManager manager = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager();
            for (Breakpoint breakpoint : breakpoints) {
                this.getPanel().getTree().removeBreakpoint(breakpoint);
                manager.removeBreakpoint(breakpoint);
            }
        }
    }

    @Override
    public void update() {
        this.getButton().setEnabled(this.getPanel().getSelectedBreakpoints().length > 0);
    }
}

