/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.StringBuilderSpinAllocator;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WildcardMethodBreakpoint
extends Breakpoint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");
    public boolean WATCH_ENTRY;
    public boolean WATCH_EXIT;
    private String myClassPattern;
    private String myMethodName;
    public static Icon ICON = MethodBreakpoint.ICON;
    public static Icon DISABLED_ICON = MethodBreakpoint.DISABLED_ICON;
    public static Icon DISABLED_DEP_ICON = MethodBreakpoint.DISABLED_DEP_ICON;
    public static final String JDOM_LABEL = "wildcard_breakpoint";

    public WildcardMethodBreakpoint(Project project) {
        super(project);
        this.WATCH_ENTRY = true;
        this.WATCH_EXIT = true;
    }

    public Key<MethodBreakpoint> getCategory() {
        return MethodBreakpoint.CATEGORY;
    }

    protected WildcardMethodBreakpoint(Project project, @NotNull String classPattern, @NotNull String methodName) {
        if (classPattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/ui/breakpoints/WildcardMethodBreakpoint.<init> must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/debugger/ui/breakpoints/WildcardMethodBreakpoint.<init> must not be null");
        }
        super(project);
        this.WATCH_ENTRY = true;
        this.WATCH_EXIT = true;
        this.myClassPattern = classPattern;
        this.myMethodName = methodName;
    }

    @Override
    public String getClassName() {
        return this.myClassPattern;
    }

    @Override
    @Nullable
    public String getShortClassName() {
        return this.getClassName();
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    @Override
    public PsiClass getPsiClass() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            buffer.append(this.myClassPattern);
            buffer.append(".");
            buffer.append(this.myMethodName);
            buffer.append("()");
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Override
    public Icon getIcon() {
        if (!this.ENABLED) {
            Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
            return master == null ? DISABLED_ICON : DISABLED_DEP_ICON;
        }
        return ICON;
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
        if (!this.matchesEvent(event)) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.ENABLED || !debugProcess.isAttached() || debugProcess.areBreakpointsMuted() || !debugProcess.getRequestsManager().findRequests(this).isEmpty()) {
            return;
        }
        try {
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            if (this.WATCH_ENTRY) {
                MethodEntryRequest entryRequest = (MethodEntryRequest)this.findRequest(debugProcess, MethodEntryRequest.class);
                if (entryRequest == null) {
                    entryRequest = requestManager.createMethodEntryRequest(this);
                } else {
                    entryRequest.disable();
                }
                entryRequest.addClassFilter(this.myClassPattern);
                debugProcess.getRequestsManager().enableRequest(entryRequest);
            }
            if (this.WATCH_EXIT) {
                MethodExitRequest exitRequest = (MethodExitRequest)this.findRequest(debugProcess, MethodExitRequest.class);
                if (exitRequest == null) {
                    exitRequest = requestManager.createMethodExitRequest(this);
                } else {
                    exitRequest.disable();
                }
                exitRequest.addClassFilter(this.myClassPattern);
                debugProcess.getRequestsManager().enableRequest(exitRequest);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    private EventRequest findRequest(DebugProcessImpl debugProcess, Class requestClass) {
        Set<EventRequest> reqSet = debugProcess.getRequestsManager().findRequests(this);
        for (EventRequest eventRequest : reqSet) {
            if (!eventRequest.getClass().equals(requestClass)) continue;
            return eventRequest;
        }
        return null;
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType refType) {
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        Location location = event.location();
        String locationQName = location.declaringType().name() + "." + location.method().name();
        String locationFileName = "";
        try {
            locationFileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            locationFileName = "";
        }
        int locationLine = location.lineNumber();
        if (event instanceof MethodEntryEvent) {
            MethodEntryEvent entryEvent = (MethodEntryEvent)event;
            Method method = entryEvent.method();
            return DebuggerBundle.message((String)"status.method.entry.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
        }
        if (event instanceof MethodExitEvent) {
            MethodExitEvent exitEvent = (MethodExitEvent)event;
            Method method = exitEvent.method();
            return DebuggerBundle.message((String)"status.method.exit.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
        }
        return "";
    }

    @Override
    public boolean isValid() {
        return this.myClassPattern != null && this.myMethodName != null;
    }

    @Override
    public void writeExternal(Element parentNode) throws WriteExternalException {
        super.writeExternal(parentNode);
        parentNode.setAttribute(JDOM_LABEL, "true");
        if (this.myClassPattern != null) {
            parentNode.setAttribute("class_name", this.myClassPattern);
        }
        if (this.myMethodName != null) {
            parentNode.setAttribute("method_name", this.myMethodName);
        }
    }

    @Override
    public PsiElement getEvaluationElement() {
        return null;
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        String methodName;
        String className;
        super.readExternal(parentNode);
        this.myClassPattern = className = parentNode.getAttributeValue("class_name");
        this.myMethodName = methodName = parentNode.getAttributeValue("method_name");
        if (className == null || methodName == null) {
            throw new InvalidDataException();
        }
    }

    public boolean matchesEvent(LocatableEvent event) {
        Method method = event.location().method();
        return method != null && this.myMethodName.equals(method.name());
    }

    public static WildcardMethodBreakpoint create(Project project, String classPattern, String methodName) {
        return new WildcardMethodBreakpoint(project, classPattern, methodName);
    }
}

