/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.DebuggerStatementEditor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointManagerListener;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog;
import com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog;
import com.intellij.debugger.ui.breakpoints.EnableBreakpointRule;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BreakpointPropertiesPanel {
    protected final Project myProject;
    private final Key<? extends Breakpoint> myBreakpointCategory;
    private JPanel myPanel;
    private final DebuggerExpressionComboBox myConditionCombo;
    private final DebuggerExpressionComboBox myLogExpressionCombo;
    private JTextField myPassCountField;
    private final FieldPanel myInstanceFiltersField;
    private final FieldPanel myClassFiltersField;
    private ClassFilter[] myClassFilters;
    private ClassFilter[] myClassExclusionFilters;
    private InstanceFilter[] myInstanceFilters;
    private JCheckBox myLogExpressionCheckBox;
    private JCheckBox myLogMessageCheckBox;
    protected JCheckBox myPassCountCheckbox;
    private JCheckBox myConditionCheckbox;
    private JCheckBox myInstanceFiltersCheckBox;
    private JCheckBox myClassFiltersCheckBox;
    private JPanel myInstanceFiltersFieldPanel;
    private JPanel myClassFiltersFieldPanel;
    private JPanel myConditionComboPanel;
    private JPanel myLogExpressionComboPanel;
    private JPanel myDependentBreakpointComboPanel;
    private JPanel mySpecialBoxPanel;
    private PsiClass myBreakpointPsiClass;
    private JRadioButton mySuspendThreadRadio;
    private JRadioButton mySuspendNoneRadio;
    private JRadioButton mySuspendAllRadio;
    private JRadioButton myDisableAgainRadio;
    private JRadioButton myLeaveEnabledRadioButton;
    private JLabel myEnableOrDisableLabel;
    private JButton myMakeDefaultButton;
    ButtonGroup mySuspendPolicyGroup;
    @NonNls
    public static final String CONTROL_LOG_MESSAGE = "logMessage";
    private BreakpointComboboxHandler myBreakpointComboboxHandler;
    private static final int MAX_COMBO_WIDTH = 300;
    private final FixedSizeButton myConditionMagnifierButton;

    public JComponent getControl(String control) {
        if (CONTROL_LOG_MESSAGE.equals(control)) {
            return this.myLogExpressionCombo;
        }
        return null;
    }

    public void dispose() {
        if (this.myBreakpointComboboxHandler != null) {
            this.myBreakpointComboboxHandler.dispose();
            this.myBreakpointComboboxHandler = null;
        }
        if (this.myConditionCombo != null) {
            this.myConditionCombo.dispose();
        }
        if (this.myLogExpressionCombo != null) {
            this.myLogExpressionCombo.dispose();
        }
    }

    private static void insert(JPanel panel, JComponent component) {
        panel.setLayout(new BorderLayout());
        panel.add((Component)component, "Center");
    }

    public BreakpointPropertiesPanel(Project project, final Key<? extends Breakpoint> breakpointCategory) {
        this.myProject = project;
        this.myBreakpointCategory = breakpointCategory;
        this.$$$setupUI$$$();
        this.mySuspendPolicyGroup = new ButtonGroup();
        this.mySuspendPolicyGroup.add(this.mySuspendAllRadio);
        this.mySuspendPolicyGroup.add(this.mySuspendThreadRadio);
        this.mySuspendPolicyGroup.add(this.mySuspendNoneRadio);
        this.updateSuspendPolicyRbFont();
        ItemListener suspendPolicyChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String defaultPolicy = DebuggerManagerEx.getInstanceEx(BreakpointPropertiesPanel.this.myProject).getBreakpointManager().getDefaultSuspendPolicy((Key<? extends Breakpoint>)breakpointCategory);
                    BreakpointPropertiesPanel.this.myMakeDefaultButton.setEnabled(!defaultPolicy.equals(BreakpointPropertiesPanel.this.getSelectedSuspendPolicy()));
                }
            }
        };
        this.mySuspendAllRadio.addItemListener(suspendPolicyChangeListener);
        this.mySuspendNoneRadio.addItemListener(suspendPolicyChangeListener);
        this.mySuspendThreadRadio.addItemListener(suspendPolicyChangeListener);
        this.myMakeDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(BreakpointPropertiesPanel.this.myProject).getBreakpointManager();
                String suspendPolicy = BreakpointPropertiesPanel.this.getSelectedSuspendPolicy();
                breakpointManager.setDefaultSuspendPolicy((Key<? extends Breakpoint>)breakpointCategory, suspendPolicy);
                BreakpointPropertiesPanel.this.updateSuspendPolicyRbFont();
                if ("SuspendThread".equals(suspendPolicy)) {
                    BreakpointPropertiesPanel.this.mySuspendThreadRadio.requestFocus();
                } else if ("SuspendNone".equals(suspendPolicy)) {
                    BreakpointPropertiesPanel.this.mySuspendNoneRadio.requestFocus();
                } else {
                    BreakpointPropertiesPanel.this.mySuspendAllRadio.requestFocus();
                }
                BreakpointPropertiesPanel.this.myMakeDefaultButton.setEnabled(false);
            }
        });
        this.myConditionCombo = new DebuggerExpressionComboBox(project, "LineBreakpoint condition");
        this.myLogExpressionCombo = new DebuggerExpressionComboBox(project, "LineBreakpoint logMessage");
        ComboBox baseBreakpointCombo = new ComboBox();
        this.myBreakpointComboboxHandler = new BreakpointComboboxHandler(this.myProject, (JComboBox)baseBreakpointCombo);
        baseBreakpointCombo.setRenderer(new BreakpointComboRenderer());
        baseBreakpointCombo.addItemListener(new ItemListener((JComboBox)baseBreakpointCombo){
            final /* synthetic */ JComboBox val$baseBreakpointCombo;
            {
                this.val$baseBreakpointCombo = jComboBox;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComboboxItem item = (ComboboxItem)this.val$baseBreakpointCombo.getSelectedItem();
                boolean enabled = item != null && item.getBreakpoint() != null;
                BreakpointPropertiesPanel.this.myLeaveEnabledRadioButton.setEnabled(enabled);
                BreakpointPropertiesPanel.this.myDisableAgainRadio.setEnabled(enabled);
                BreakpointPropertiesPanel.this.myEnableOrDisableLabel.setEnabled(enabled);
            }
        });
        this.myInstanceFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPropertiesPanel.this.reloadInstanceFilters();
                EditInstanceFiltersDialog _dialog = new EditInstanceFiltersDialog(BreakpointPropertiesPanel.this.myProject);
                _dialog.setFilters(BreakpointPropertiesPanel.this.myInstanceFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    BreakpointPropertiesPanel.access$1402(BreakpointPropertiesPanel.this, _dialog.getFilters());
                    BreakpointPropertiesPanel.this.updateInstanceFilterEditor(true);
                }
            }
        }, null);
        this.myClassFiltersField = new FieldPanel((JTextField)new MyTextField(), "", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPropertiesPanel.this.reloadClassFilters();
                TreeClassChooser.ClassFilter classFilter = BreakpointPropertiesPanel.this.createClassConditionFilter();
                EditClassFiltersDialog _dialog = new EditClassFiltersDialog(BreakpointPropertiesPanel.this.myProject, classFilter);
                _dialog.setFilters(BreakpointPropertiesPanel.this.myClassFilters, BreakpointPropertiesPanel.this.myClassExclusionFilters);
                _dialog.show();
                if (_dialog.getExitCode() == 0) {
                    BreakpointPropertiesPanel.access$1502(BreakpointPropertiesPanel.this, _dialog.getFilters());
                    BreakpointPropertiesPanel.access$1602(BreakpointPropertiesPanel.this, _dialog.getExclusionFilters());
                    BreakpointPropertiesPanel.this.updateClassFilterEditor(true);
                }
            }
        }, null);
        ToolTipManager.sharedInstance().registerComponent(this.myClassFiltersField.getTextField());
        ToolTipManager.sharedInstance().registerComponent(this.myInstanceFiltersField.getTextField());
        JComponent specialBox = this.createSpecialBox();
        if (specialBox != null) {
            BreakpointPropertiesPanel.insert(this.mySpecialBoxPanel, specialBox);
        } else {
            this.mySpecialBoxPanel.setVisible(false);
        }
        JPanel conditionPanel = new JPanel(new BorderLayout());
        conditionPanel.add((Component)this.myConditionCombo, "Center");
        this.myConditionMagnifierButton = new FixedSizeButton((JComponent)this.myConditionCombo);
        conditionPanel.add((Component)this.myConditionMagnifierButton, "East");
        this.myConditionMagnifierButton.setFocusable(false);
        this.myConditionMagnifierButton.addActionListener((ActionListener)new MagnifierButtonAction(project, this.myConditionCombo, this.myConditionCheckbox.getText()));
        BreakpointPropertiesPanel.insert(this.myConditionComboPanel, conditionPanel);
        BreakpointPropertiesPanel.insert(this.myLogExpressionComboPanel, this.myLogExpressionCombo);
        BreakpointPropertiesPanel.insert(this.myDependentBreakpointComboPanel, (JComponent)baseBreakpointCombo);
        BreakpointPropertiesPanel.insert(this.myInstanceFiltersFieldPanel, (JComponent)this.myInstanceFiltersField);
        BreakpointPropertiesPanel.insert(this.myClassFiltersFieldPanel, (JComponent)this.myClassFiltersField);
        DebuggerUIUtil.enableEditorOnCheck(this.myLogExpressionCheckBox, this.myLogExpressionCombo);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointPropertiesPanel.this.updateCheckboxes();
            }
        };
        this.myPassCountCheckbox.addActionListener(listener);
        this.myConditionCheckbox.addActionListener(listener);
        this.myInstanceFiltersCheckBox.addActionListener(listener);
        this.myClassFiltersCheckBox.addActionListener(listener);
        DebuggerUIUtil.focusEditorOnCheck(this.myPassCountCheckbox, this.myPassCountField);
        DebuggerUIUtil.focusEditorOnCheck(this.myConditionCheckbox, this.myConditionCombo);
        DebuggerUIUtil.focusEditorOnCheck(this.myLogExpressionCheckBox, this.myLogExpressionCombo);
        DebuggerUIUtil.focusEditorOnCheck(this.myInstanceFiltersCheckBox, this.myInstanceFiltersField.getTextField());
        DebuggerUIUtil.focusEditorOnCheck(this.myClassFiltersCheckBox, this.myClassFiltersField.getTextField());
    }

    private String getSelectedSuspendPolicy() {
        if (this.mySuspendThreadRadio.isSelected()) {
            return "SuspendThread";
        }
        if (this.mySuspendNoneRadio.isSelected()) {
            return "SuspendNone";
        }
        return "SuspendAll";
    }

    private void updateSuspendPolicyRbFont() {
        String defPolicy = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().getDefaultSuspendPolicy(this.myBreakpointCategory);
        Font font = this.mySuspendAllRadio.getFont().deriveFont(0);
        Font boldFont = font.deriveFont(1);
        this.mySuspendAllRadio.setFont("SuspendAll".equals(defPolicy) ? boldFont : font);
        this.mySuspendThreadRadio.setFont("SuspendThread".equals(defPolicy) ? boldFont : font);
        this.mySuspendNoneRadio.setFont("SuspendNone".equals(defPolicy) ? boldFont : font);
    }

    protected TreeClassChooser.ClassFilter createClassConditionFilter() {
        TreeClassChooser.ClassFilter classFilter = this.myBreakpointPsiClass != null ? new TreeClassChooser.ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                return BreakpointPropertiesPanel.this.myBreakpointPsiClass == aClass || aClass.isInheritor(BreakpointPropertiesPanel.this.myBreakpointPsiClass, true);
            }
        } : null;
        return classFilter;
    }

    protected JComponent createSpecialBox() {
        return null;
    }

    public void initFrom(Breakpoint breakpoint) {
        this.myBreakpointComboboxHandler.initFrom(breakpoint);
        this.myPassCountField.setText(breakpoint.COUNT_FILTER > 0 ? Integer.toString(breakpoint.COUNT_FILTER) : "");
        PsiElement context = breakpoint.getEvaluationElement();
        this.myPassCountCheckbox.setSelected(breakpoint.COUNT_FILTER_ENABLED);
        this.myConditionCheckbox.setSelected(breakpoint.CONDITION_ENABLED);
        if ("SuspendNone".equals(breakpoint.SUSPEND_POLICY)) {
            this.mySuspendPolicyGroup.setSelected(this.mySuspendNoneRadio.getModel(), true);
        } else if ("SuspendThread".equals(breakpoint.SUSPEND_POLICY)) {
            this.mySuspendPolicyGroup.setSelected(this.mySuspendThreadRadio.getModel(), true);
        } else {
            this.mySuspendPolicyGroup.setSelected(this.mySuspendAllRadio.getModel(), true);
        }
        this.myLogMessageCheckBox.setSelected(breakpoint.LOG_ENABLED);
        this.myLogExpressionCheckBox.setSelected(breakpoint.LOG_EXPRESSION_ENABLED);
        this.myConditionCombo.setContext(context);
        this.myConditionCombo.setText((TextWithImports)(breakpoint.getCondition() != null ? breakpoint.getCondition() : new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "")));
        this.myLogExpressionCombo.setContext(context);
        this.myLogExpressionCombo.setText((TextWithImports)(breakpoint.getLogMessage() != null ? breakpoint.getLogMessage() : new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "")));
        this.myLogExpressionCombo.setEnabled(breakpoint.LOG_EXPRESSION_ENABLED);
        this.myInstanceFiltersCheckBox.setSelected(breakpoint.INSTANCE_FILTERS_ENABLED);
        this.myInstanceFiltersField.setEnabled(breakpoint.INSTANCE_FILTERS_ENABLED);
        this.myInstanceFiltersField.getTextField().setEditable(breakpoint.INSTANCE_FILTERS_ENABLED);
        this.myInstanceFilters = breakpoint.getInstanceFilters();
        this.updateInstanceFilterEditor(true);
        this.myClassFiltersCheckBox.setSelected(breakpoint.CLASS_FILTERS_ENABLED);
        this.myClassFiltersField.setEnabled(breakpoint.CLASS_FILTERS_ENABLED);
        this.myClassFiltersField.getTextField().setEditable(breakpoint.CLASS_FILTERS_ENABLED);
        this.myClassFilters = breakpoint.getClassFilters();
        this.myClassExclusionFilters = breakpoint.getClassExclusionFilters();
        this.updateClassFilterEditor(true);
        this.myBreakpointPsiClass = breakpoint.getPsiClass();
        this.updateCheckboxes();
    }

    public void saveTo(Breakpoint breakpoint, Runnable afterUpdate) {
        this.myBreakpointComboboxHandler.saveTo(breakpoint, this.myLeaveEnabledRadioButton.isSelected());
        try {
            int count;
            String text = this.myPassCountField.getText().trim();
            breakpoint.COUNT_FILTER = count = !"".equals(text) ? Integer.parseInt(text) : 0;
            if (breakpoint.COUNT_FILTER < 0) {
                breakpoint.COUNT_FILTER = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        breakpoint.COUNT_FILTER_ENABLED = breakpoint.COUNT_FILTER > 0 ? this.myPassCountCheckbox.isSelected() : false;
        breakpoint.setCondition(this.myConditionCombo.getText());
        breakpoint.CONDITION_ENABLED = !breakpoint.getCondition().isEmpty() ? this.myConditionCheckbox.isSelected() : false;
        breakpoint.setLogMessage(this.myLogExpressionCombo.getText());
        breakpoint.LOG_EXPRESSION_ENABLED = !breakpoint.getLogMessage().isEmpty() ? this.myLogExpressionCheckBox.isSelected() : false;
        breakpoint.LOG_ENABLED = this.myLogMessageCheckBox.isSelected();
        breakpoint.SUSPEND_POLICY = this.getSelectedSuspendPolicy();
        this.reloadInstanceFilters();
        this.reloadClassFilters();
        this.updateInstanceFilterEditor(true);
        this.updateClassFilterEditor(true);
        breakpoint.INSTANCE_FILTERS_ENABLED = this.myInstanceFiltersField.getText().length() > 0 ? this.myInstanceFiltersCheckBox.isSelected() : false;
        breakpoint.CLASS_FILTERS_ENABLED = this.myClassFiltersField.getText().length() > 0 ? this.myClassFiltersCheckBox.isSelected() : false;
        breakpoint.setClassFilters(this.myClassFilters);
        breakpoint.setClassExclusionFilters(this.myClassExclusionFilters);
        breakpoint.setInstanceFilters(this.myInstanceFilters);
        this.myConditionCombo.addRecent(this.myConditionCombo.getText());
        this.myLogExpressionCombo.addRecent(this.myLogExpressionCombo.getText());
        breakpoint.updateUI(afterUpdate);
    }

    private String concatWith(List<String> s, String concator) {
        String result = "";
        for (String str : s) {
            result = result + str + concator;
        }
        if (result.length() > 0) {
            return result.substring(0, result.length() - concator.length());
        }
        return "";
    }

    private String concatWithEx(List<String> s, String concator, int N, String NthConcator) {
        String result = "";
        int i = 1;
        Iterator<String> iterator = s.iterator();
        while (iterator.hasNext()) {
            String str = iterator.next();
            result = result + str;
            if (iterator.hasNext()) {
                result = i % N == 0 ? result + NthConcator : result + concator;
            }
            ++i;
        }
        return result;
    }

    private void updateInstanceFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = 0; i < this.myInstanceFilters.length; ++i) {
            InstanceFilter instanceFilter = this.myInstanceFilters[i];
            if (!instanceFilter.isEnabled()) continue;
            filters.add(Long.toString(instanceFilter.getId()));
        }
        if (updateText) {
            String editorText = this.concatWith(filters, " ");
            this.myInstanceFiltersField.setText(editorText);
        }
        String tipText = this.concatWithEx(filters, " ", (int)Math.sqrt(this.myInstanceFilters.length) + 1, "\n");
        this.myInstanceFiltersField.getTextField().setToolTipText(tipText);
    }

    private void reloadInstanceFilters() {
        int i;
        String filtersText = this.myInstanceFiltersField.getText();
        ArrayList<InstanceFilter> idxs = new ArrayList<InstanceFilter>();
        int startNumber = -1;
        for (i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && Character.isDigit(filtersText.charAt(i))) {
                if (startNumber != -1) continue;
                startNumber = i;
                continue;
            }
            if (startNumber < 0) continue;
            idxs.add(InstanceFilter.create(filtersText.substring(startNumber, i)));
            startNumber = -1;
        }
        for (i = 0; i < this.myInstanceFilters.length; ++i) {
            InstanceFilter instanceFilter = this.myInstanceFilters[i];
            if (instanceFilter.isEnabled()) continue;
            idxs.add(instanceFilter);
        }
        this.myInstanceFilters = idxs.toArray(new InstanceFilter[idxs.size()]);
    }

    private void updateClassFilterEditor(boolean updateText) {
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = 0; i < this.myClassFilters.length; ++i) {
            ClassFilter classFilter = this.myClassFilters[i];
            if (!classFilter.isEnabled()) continue;
            filters.add(classFilter.getPattern());
        }
        ArrayList<String> excludeFilters = new ArrayList<String>();
        for (int i = 0; i < this.myClassExclusionFilters.length; ++i) {
            ClassFilter classFilter = this.myClassExclusionFilters[i];
            if (!classFilter.isEnabled()) continue;
            excludeFilters.add("-" + classFilter.getPattern());
        }
        if (updateText) {
            String editorText = this.concatWith(filters, " ");
            if (filters.size() > 0) {
                editorText = editorText + " ";
            }
            editorText = editorText + this.concatWith(excludeFilters, " ");
            this.myClassFiltersField.setText(editorText);
        }
        int width = (int)Math.sqrt(this.myClassExclusionFilters.length + this.myClassFilters.length) + 1;
        String tipText = this.concatWithEx(filters, " ", width, "\n");
        if (filters.size() > 0) {
            tipText = tipText + "\n";
        }
        tipText = tipText + this.concatWithEx(excludeFilters, " ", width, "\n");
        this.myClassFiltersField.getTextField().setToolTipText(tipText);
    }

    private void reloadClassFilters() {
        ClassFilter classFilter;
        int i;
        String filtersText = this.myClassFiltersField.getText();
        ArrayList<ClassFilter> classFilters = new ArrayList<ClassFilter>();
        ArrayList<ClassFilter> exclusionFilters = new ArrayList<ClassFilter>();
        int startFilter = -1;
        for (i = 0; i <= filtersText.length(); ++i) {
            if (i < filtersText.length() && !Character.isWhitespace(filtersText.charAt(i))) {
                if (startFilter != -1) continue;
                startFilter = i;
                continue;
            }
            if (startFilter < 0) continue;
            if (filtersText.charAt(startFilter) == '-') {
                exclusionFilters.add(new ClassFilter(filtersText.substring(startFilter + 1, i)));
            } else {
                classFilters.add(new ClassFilter(filtersText.substring(startFilter, i)));
            }
            startFilter = -1;
        }
        for (i = 0; i < this.myClassFilters.length; ++i) {
            classFilter = this.myClassFilters[i];
            if (classFilter.isEnabled()) continue;
            classFilters.add(classFilter);
        }
        for (i = 0; i < this.myClassExclusionFilters.length; ++i) {
            classFilter = this.myClassExclusionFilters[i];
            if (classFilter.isEnabled()) continue;
            exclusionFilters.add(classFilter);
        }
        this.myClassFilters = classFilters.toArray(new ClassFilter[classFilters.size()]);
        this.myClassExclusionFilters = exclusionFilters.toArray(new ClassFilter[exclusionFilters.size()]);
    }

    public void setEnabled(boolean enabled) {
        this.myPanel.setEnabled(enabled);
        Component[] components = this.myPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            component.setEnabled(enabled);
        }
    }

    protected void updateCheckboxes() {
        int i;
        JCheckBox[] checkBoxes = new JCheckBox[]{this.myConditionCheckbox, this.myInstanceFiltersCheckBox, this.myClassFiltersCheckBox};
        JCheckBox selected = null;
        for (i = 0; i < checkBoxes.length; ++i) {
            if (!checkBoxes[i].isSelected()) continue;
            selected = checkBoxes[i];
            break;
        }
        if (selected != null) {
            this.myPassCountCheckbox.setEnabled(false);
        } else {
            this.myPassCountCheckbox.setEnabled(true);
        }
        for (i = 0; i < checkBoxes.length; ++i) {
            checkBoxes[i].setEnabled(!this.myPassCountCheckbox.isSelected());
        }
        this.myPassCountField.setEditable(this.myPassCountCheckbox.isSelected());
        this.myPassCountField.setEnabled(this.myPassCountCheckbox.isSelected());
        this.myConditionCombo.setEnabled(this.myConditionCheckbox.isSelected());
        this.myConditionMagnifierButton.setEnabled(this.myConditionCheckbox.isSelected());
        this.myInstanceFiltersField.setEnabled(this.myInstanceFiltersCheckBox.isSelected());
        this.myInstanceFiltersField.getTextField().setEditable(this.myInstanceFiltersCheckBox.isSelected());
        this.myClassFiltersField.setEnabled(this.myClassFiltersCheckBox.isSelected());
        this.myClassFiltersField.getTextField().setEditable(this.myClassFiltersCheckBox.isSelected());
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    static /* synthetic */ InstanceFilter[] access$1402(BreakpointPropertiesPanel x0, InstanceFilter[] x1) {
        x0.myInstanceFilters = x1;
        return x1;
    }

    static /* synthetic */ ClassFilter[] access$1502(BreakpointPropertiesPanel x0, ClassFilter[] x1) {
        x0.myClassFilters = x1;
        return x1;
    }

    static /* synthetic */ ClassFilter[] access$1602(BreakpointPropertiesPanel x0, ClassFilter[] x1) {
        x0.myClassExclusionFilters = x1;
        return x1;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel3;
        JButton jButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JCheckBox jCheckBox5;
        JPanel jPanel4;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JLabel jLabel;
        JPanel jPanel5;
        JCheckBox jCheckBox6;
        JPanel jPanel6;
        JPanel jPanel7;
        this.myPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySpecialBoxPanel = jPanel6 = new JPanel();
        ((Component)jPanel6).setVisible(true);
        jPanel8.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 5), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.breakpoint.properties.panel.group.actions"), 0, 0, null, null));
        this.myLogMessageCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.log.message"));
        jPanel9.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.depends.on"));
        jPanel9.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 4, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel10.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myDependentBreakpointComboPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 15, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel5, new GridConstraints(0, 1, 1, 3, 0, 3, 3, 0, null, null, null));
        this.myEnableOrDisableLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.dependency.type.lable"));
        jPanel10.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDisableAgainRadio = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.depends.disable.again"));
        jPanel10.add((Component)jRadioButton5, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLeaveEnabledRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.depends.leave.enabled"));
        jPanel10.add((Component)jRadioButton4, new GridConstraints(1, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel9.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel12.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myLogExpressionComboPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 1, 1, 7, 0, new Dimension(-1, 22), null, new Dimension(-1, 22)));
        this.myLogExpressionCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.log.expression"));
        jPanel11.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel13, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel13.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.breakpoint.properties.panel.group.suspend.policy"), 0, 0, null, null));
        this.mySuspendThreadRadio = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.suspend.thread"));
        jPanel13.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySuspendNoneRadio = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.suspend.none"));
        jPanel13.add((Component)jRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySuspendAllRadio = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.suspend.all"));
        jPanel13.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel13.add((Component)spacer4, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMakeDefaultButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.suspend.default"));
        jPanel13.add((Component)jButton, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(2, 2, 5, 5), -1, 7, false, false));
        jPanel7.add((Component)jPanel14, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.breakpoint.properties.panel.group.conditions"), 0, 0, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel14.add((Component)jPanel15, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel16, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myConditionComboPanel = jPanel3 = new JPanel();
        jPanel16.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, new Dimension(-1, 22), null, new Dimension(-1, 22)));
        Spacer spacer5 = new Spacer();
        jPanel16.add((Component)spacer5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myConditionCheckbox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.condition"));
        jCheckBox4.setMargin(new Insets(2, 2, 0, 2));
        jPanel15.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel14.add((Component)jPanel17, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myInstanceFiltersCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.instance.filters"));
        jCheckBox3.setMargin(new Insets(2, 2, 0, 2));
        jPanel17.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel17.add((Component)jPanel18, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel18.add((Component)spacer6, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        this.myInstanceFiltersFieldPanel = jPanel2 = new JPanel();
        jPanel18.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel14.add((Component)jPanel19, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myClassFiltersCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.class.filters"));
        jCheckBox2.setMargin(new Insets(2, 2, 0, 2));
        jPanel19.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel19.add((Component)jPanel20, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myClassFiltersFieldPanel = jPanel = new JPanel();
        jPanel20.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel20.add((Component)spacer7, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel14.add((Component)jPanel21, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myPassCountCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/DebuggerBundle").getString("breakpoint.properties.panel.option.pass.count"));
        jCheckBox.setMargin(new Insets(2, 2, 0, 2));
        jPanel21.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel21.add((Component)jPanel22, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPassCountField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jTextField.setHorizontalAlignment(10);
        jPanel22.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(15, -1), null));
        Spacer spacer8 = new Spacer();
        jPanel22.add((Component)spacer8, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(15, -1), null));
        Spacer spacer9 = new Spacer();
        jPanel14.add((Component)spacer9, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MagnifierButtonAction
    implements ActionListener {
        private final Project myProject;
        private final CompletionEditor myTargetEditor;
        private final String myDialogTitle;
        private DebuggerStatementEditor myEditor;

        private MagnifierButtonAction(Project project, CompletionEditor targetEditor, String dialogTitle) {
            this.myProject = project;
            this.myTargetEditor = targetEditor;
            this.myDialogTitle = dialogTitle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DialogWrapper(this.myTargetEditor, true){

                public void show() {
                    this.setTitle(MagnifierButtonAction.this.myDialogTitle);
                    this.setModal(true);
                    this.init();
                    super.show();
                }

                public JComponent getPreferredFocusedComponent() {
                    return MagnifierButtonAction.this.myEditor;
                }

                @Nullable
                protected JComponent createCenterPanel() {
                    JPanel panel = new JPanel(new BorderLayout());
                    MagnifierButtonAction.this.myEditor = new DebuggerStatementEditor(MagnifierButtonAction.this.myProject, MagnifierButtonAction.this.myTargetEditor.getContext(), MagnifierButtonAction.this.myTargetEditor.getRecentsId(), DefaultCodeFragmentFactory.getInstance());
                    MagnifierButtonAction.this.myEditor.setPreferredSize(new Dimension(400, 150));
                    MagnifierButtonAction.this.myEditor.setText(MagnifierButtonAction.this.myTargetEditor.getText());
                    panel.add((Component)MagnifierButtonAction.this.myEditor, "Center");
                    return panel;
                }

                protected void doOKAction() {
                    MagnifierButtonAction.this.myTargetEditor.setText(MagnifierButtonAction.this.myEditor.getText());
                    super.doOKAction();
                }
            }.show();
        }
    }

    private static class BreakpointComboRenderer
    extends DefaultListCellRenderer {
        private BreakpointComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setPreferredSize(new Dimension(300, this.getPreferredSize().height));
            Breakpoint breakpoint = ((ComboboxItem)value).getBreakpoint();
            String text = breakpoint != null ? breakpoint.getDisplayName() : DebuggerBundle.message((String)"value.none", (Object[])new Object[0]);
            this.setText(text);
            Icon icon = breakpoint != null ? (breakpoint instanceof BreakpointWithHighlighter ? (breakpoint.ENABLED ? ((BreakpointWithHighlighter)breakpoint).getSetIcon(false) : ((BreakpointWithHighlighter)breakpoint).getDisabledIcon(false)) : breakpoint.getIcon()) : null;
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            return this;
        }
    }

    private class BreakpointComboboxHandler
    implements BreakpointManagerListener {
        private final JComboBox myCombo;
        private final BreakpointManager myBreakpointManager;
        private Breakpoint myCurrentBreakpoint = null;

        public BreakpointComboboxHandler(Project project, JComboBox breakpointCombo) {
            this.myCombo = breakpointCombo;
            this.myBreakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
            this.myBreakpointManager.addBreakpointManagerListener(this);
        }

        public void initFrom(Breakpoint breakpoint) {
            this.myCurrentBreakpoint = breakpoint;
            this.fillCombobox();
        }

        public void saveTo(Breakpoint slaveBreakpoint, boolean leaveEnabled) {
            this.myBreakpointManager.removeBreakpointRule(slaveBreakpoint);
            Breakpoint masterBreakpoint = ((ComboboxItem)this.myCombo.getSelectedItem()).getBreakpoint();
            if (masterBreakpoint != null) {
                this.myBreakpointManager.addBreakpointRule(new EnableBreakpointRule(this.myBreakpointManager, masterBreakpoint, slaveBreakpoint, leaveEnabled));
            }
        }

        @Override
        public void breakpointsChanged() {
            this.fillCombobox();
        }

        public void dispose() {
            this.myBreakpointManager.removeBreakpointManagerListener(this);
        }

        private void fillCombobox() {
            boolean leaveEnabled;
            ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>(this.myBreakpointManager.getBreakpoints());
            if (this.myCurrentBreakpoint != null) {
                breakpoints.remove(this.myCurrentBreakpoint);
            }
            this.myCombo.setModel(new BreakpointComboboxModel(breakpoints.toArray(new Breakpoint[breakpoints.size()])));
            EnableBreakpointRule rule = this.myCurrentBreakpoint != null ? this.myBreakpointManager.findBreakpointRule(this.myCurrentBreakpoint) : null;
            Breakpoint baseBreakpoint = rule != null ? rule.getMasterBreakpoint() : null;
            boolean bl = leaveEnabled = rule != null && rule.isLeaveEnabled();
            if (leaveEnabled) {
                BreakpointPropertiesPanel.this.myLeaveEnabledRadioButton.setSelected(true);
            } else {
                BreakpointPropertiesPanel.this.myDisableAgainRadio.setSelected(true);
            }
            ((BreakpointComboboxModel)this.myCombo.getModel()).selectBreakpoint(baseBreakpoint);
        }
    }

    private static class ComboboxItem {
        private final Breakpoint breakpoint;

        public ComboboxItem() {
            this.breakpoint = null;
        }

        public ComboboxItem(@NotNull Breakpoint breakpoint) {
            if (breakpoint == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/ui/breakpoints/BreakpointPropertiesPanel$ComboboxItem.<init> must not be null");
            }
            this.breakpoint = breakpoint;
        }

        public Breakpoint getBreakpoint() {
            return this.breakpoint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComboboxItem comboboxItem = (ComboboxItem)o;
            return !(this.breakpoint != null ? !this.breakpoint.equals(comboboxItem.breakpoint) : comboboxItem.breakpoint != null);
        }

        public int hashCode() {
            return this.breakpoint != null ? this.breakpoint.hashCode() : 0;
        }
    }

    private static class BreakpointComboboxModel
    extends DefaultComboBoxModel {
        private final ComboboxItem[] myItems;

        public BreakpointComboboxModel(Breakpoint[] breakpoints) {
            this.myItems = new ComboboxItem[breakpoints.length + 1];
            this.myItems[0] = new ComboboxItem();
            for (int idx = 0; idx < breakpoints.length; ++idx) {
                this.myItems[idx + 1] = new ComboboxItem(breakpoints[idx]);
            }
        }

        @Override
        public int getSize() {
            return this.myItems.length;
        }

        @Override
        public ComboboxItem getElementAt(int index) {
            return this.myItems[index];
        }

        public void selectBreakpoint(Breakpoint breakpoint) {
            for (int idx = 0; idx < this.myItems.length; ++idx) {
                ComboboxItem item = this.myItems[idx];
                if (!(breakpoint == null ? item.getBreakpoint() == null : breakpoint.equals(item.getBreakpoint()))) continue;
                if (item.equals(this.getSelectedItem())) break;
                this.setSelectedItem(item);
                break;
            }
        }
    }

    private class MyTextField
    extends JTextField {
        @Override
        public String getToolTipText(MouseEvent event) {
            BreakpointPropertiesPanel.this.reloadClassFilters();
            BreakpointPropertiesPanel.this.updateClassFilterEditor(false);
            BreakpointPropertiesPanel.this.reloadInstanceFilters();
            BreakpointPropertiesPanel.this.updateInstanceFilterEditor(false);
            String toolTipText = super.getToolTipText(event);
            return this.getToolTipText().length() == 0 ? null : toolTipText;
        }

        @Override
        public JToolTip createToolTip() {
            JToolTip toolTip = new JToolTip(){
                {
                    this.setUI((ComponentUI)new MultiLineTooltipUI());
                }
            };
            toolTip.setComponent(this);
            return toolTip;
        }
    }
}

