/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;

public class DebuggerContextUtil {
    public static void setStackFrame(DebuggerStateManager manager, StackFrameProxyImpl stackFrame) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl context = manager.getContext();
        if (context == null) {
            return;
        }
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(context.getDebuggerSession(), context.getSuspendContext(), stackFrame.threadProxy(), stackFrame);
        manager.setState(newContext, context.getDebuggerSession().getState(), 7, null);
    }

    public static void setThread(DebuggerStateManager contextManager, ThreadDescriptorImpl item) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebuggerContextImpl context = contextManager.getContext();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(context.getDebuggerSession(), item.getSuspendContext(), item.getThreadReference(), null);
        contextManager.setState(newContext, context.getDebuggerSession().getState(), 8, null);
    }

    public static DebuggerContextImpl createDebuggerContext(@NotNull DebuggerSession session, SuspendContextImpl suspendContext) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/impl/DebuggerContextUtil.createDebuggerContext must not be null");
        }
        return DebuggerContextImpl.createDebuggerContext(session, suspendContext, suspendContext != null ? suspendContext.getThread() : null, null);
    }
}

