/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;

public class RunToCursorActionHandler
extends DebuggerActionHandler {
    private final boolean myIgnoreBreakpoints;

    public RunToCursorActionHandler() {
        this(false);
    }

    protected RunToCursorActionHandler(boolean ignoreBreakpoints) {
        this.myIgnoreBreakpoints = ignoreBreakpoints;
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        FileType fileType;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/RunToCursorActionHandler.isEnabled must not be null");
        }
        Editor editor = (Editor)event.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        FileType fileType2 = fileType = virtualFile != null ? fileTypeManager.getFileTypeByFile(virtualFile) : null;
        if (DebuggerUtils.supportsJVMDebugging((FileType)fileType) || DebuggerUtils.supportsJVMDebugging((PsiFile)file)) {
            DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
            return debuggerSession != null && debuggerSession.isPaused();
        }
        return false;
    }

    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/actions/RunToCursorActionHandler.perform must not be null");
        }
        Editor editor = (Editor)event.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project).getContext();
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        context.getDebuggerSession().runToCursor(editor.getDocument(), editor.getCaretModel().getLogicalPosition().line, this.myIgnoreBreakpoints);
    }
}

