/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunManagerSettingsImpl
implements RunManagerSettings {
    @NonNls
    public static final String RUN_MANAGER_COMPONENT_NAME = "RunManager";
    @NonNls
    private static final String PROJECT_RUN_MANAGER = "ProjectRunConfigurationManager";
    @NonNls
    public static final String CONFIGURATION_ELEMENT = "configuration";
    private SettingsXmlFile myWorkspaceFile;
    private SettingsXmlFile myProjectFile;
    private List<SettingsXmlFile> mySharedConfigurationFiles;

    public RunManagerSettingsImpl(@NotNull File workspaceFile, @Nullable File projectFile, @Nullable File[] sharedConfigurationFiles, ConversionContextImpl context) throws CannotConvertException {
        if (workspaceFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/conversion/impl/RunManagerSettingsImpl.<init> must not be null");
        }
        if (workspaceFile.exists()) {
            this.myWorkspaceFile = context.getOrCreateFile(workspaceFile);
        }
        if (projectFile != null && projectFile.exists()) {
            this.myProjectFile = context.getOrCreateFile(projectFile);
        }
        this.mySharedConfigurationFiles = new ArrayList<SettingsXmlFile>();
        if (sharedConfigurationFiles != null) {
            for (File file : sharedConfigurationFiles) {
                this.mySharedConfigurationFiles.add(context.getOrCreateFile(file));
            }
        }
    }

    @Override
    @NotNull
    public Collection<? extends Element> getRunConfigurations() {
        ArrayList<Element> result = new ArrayList<Element>();
        if (this.myWorkspaceFile != null) {
            result.addAll(JDomConvertingUtil.getChildren(this.myWorkspaceFile.findComponent(RUN_MANAGER_COMPONENT_NAME), CONFIGURATION_ELEMENT));
        }
        if (this.myProjectFile != null) {
            result.addAll(JDomConvertingUtil.getChildren(this.myProjectFile.findComponent(PROJECT_RUN_MANAGER), CONFIGURATION_ELEMENT));
        }
        for (SettingsXmlFile file : this.mySharedConfigurationFiles) {
            result.addAll(JDomConvertingUtil.getChildren(file.getRootElement(), CONFIGURATION_ELEMENT));
        }
        ArrayList<Element> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/conversion/impl/RunManagerSettingsImpl.getRunConfigurations must not return null");
        }
        return arrayList;
    }

    public Collection<File> getAffectedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.myWorkspaceFile != null) {
            files.add(this.myWorkspaceFile.getFile());
        }
        if (this.myProjectFile != null) {
            files.add(this.myProjectFile.getFile());
        }
        for (SettingsXmlFile file : this.mySharedConfigurationFiles) {
            files.add(file.getFile());
        }
        return files;
    }
}

