/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobImpl;
import com.intellij.concurrency.JobScheduler;
import com.intellij.concurrency.PrioritizedFutureTask;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.ApplicationImpl;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;

@NonNls
public class JobSchedulerImpl
extends JobScheduler
implements Disposable {
    public static final int CORES_COUNT = Runtime.getRuntime().availableProcessors();
    private static final ThreadFactory WORKERS_FACTORY = new ThreadFactory(){
        int i;

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "JobScheduler pool " + this.i++ + "/" + CORES_COUNT);
            thread.setPriority(5);
            return thread;
        }
    };
    private static final Lock ourSuspensionLock = new ReentrantLock();
    private static final PriorityBlockingQueue<Runnable> ourQueue = new PriorityBlockingQueue<Runnable>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable poll() {
            Runnable result = (Runnable)super.poll();
            ourSuspensionLock.lock();
            try {
                Runnable runnable = result;
                return runnable;
            }
            finally {
                ourSuspensionLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            Runnable result = (Runnable)super.poll(timeout, unit);
            ourSuspensionLock.lock();
            try {
                Runnable runnable = result;
                return runnable;
            }
            finally {
                ourSuspensionLock.unlock();
            }
        }
    };
    private static final ThreadPoolExecutor ourExecutor = new ThreadPoolExecutor(CORES_COUNT, Integer.MAX_VALUE, 600L, TimeUnit.SECONDS, ourQueue, WORKERS_FACTORY){

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            PrioritizedFutureTask task = (PrioritizedFutureTask)r;
            if (task.isParentThreadHasReadAccess()) {
                ApplicationImpl.setExceptionalThreadWithReadAccessFlag(true);
            }
            task.signalStarted();
            super.beforeExecute(t, r);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            ApplicationImpl.setExceptionalThreadWithReadAccessFlag(false);
            PrioritizedFutureTask task = (PrioritizedFutureTask)r;
            task.signalDone();
        }
    };
    private static volatile long ourJobsCounter = 0L;

    public static void execute(Runnable task) {
        ourExecutor.execute(task);
    }

    public static int currentTaskIndex() {
        PrioritizedFutureTask topTask = (PrioritizedFutureTask)ourQueue.peek();
        return topTask == null ? 0 : topTask.getTaskIndex();
    }

    public static long currentJobIndex() {
        return ourJobsCounter++;
    }

    public static void suspend() {
        ourSuspensionLock.lock();
    }

    public static void resume() {
        ourSuspensionLock.unlock();
    }

    public <T> Job<T> createJob(String title, int priority) {
        return new JobImpl(title, priority);
    }

    public void dispose() {
        ((ThreadPoolExecutor)((Object)JobSchedulerImpl.getScheduler())).getQueue().clear();
    }
}

